/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.context;


import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.routing.Foreach;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class MunitBeanDefinitionScopper {

    public static void makeBeanDefinitionSingletonIfApplicable(BeanDefinition beanDefinition) throws ClassNotFoundException {
        scopeOutFlowControl(beanDefinition);
        scopeOutSpecialBeans(beanDefinition);
    }

    protected static void scopeOutFlowControl(BeanDefinition beanDefinition) throws ClassNotFoundException {
        Class<?> beanType = Class.forName(beanDefinition.getBeanClassName());

        if (Foreach.class.isAssignableFrom(beanType)) {
            beanDefinition.setScope(ConfigurableBeanFactory.SCOPE_SINGLETON);
        }
    }

    protected static void scopeOutSpecialBeans(BeanDefinition beanDefinition) throws ClassNotFoundException {
        Class<?> beanType = Class.forName(beanDefinition.getBeanClassName());

        if (AbstractXmlTransformer.class.isAssignableFrom(beanType)) {
            beanDefinition.setScope(ConfigurableBeanFactory.SCOPE_SINGLETON);
        }
    }
}
