/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.context;

import org.mule.munit.common.MunitCore;

import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;


/**
 * <p>
 * We override the {@link DOMParser} implementation to retrieve the line number of the XML
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public class MunitDomParser extends DOMParser
{

    public static final String NAMESPACE = "http://www.mule.org/munit";
    XMLLocator xmlLocator;

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException
    {
        this.xmlLocator = locator;
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException
    {
        String location = String.valueOf(xmlLocator.getLineNumber());
        attributes.addAttribute(new QName(MunitCore.LINE_NUMBER_ELEMENT_ATTRIBUTE, null,
                                          MunitCore.LINE_NUMBER_ELEMENT_ATTRIBUTE, NAMESPACE), "CDATA", location);
        super.startElement(element, attributes, augs);
    }


}
