/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.context;

import java.util.List;
import java.util.Properties;

/**
 * <p>
 * The configuration of the mocking elements for Munit
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MockingConfiguration
{

    private boolean mockInbounds;
    private List<String> mockingExcludedFlows;
    private boolean mockConnectors;
    private Properties startUpProperties;

    public MockingConfiguration(boolean mockInbounds, List<String> mockingExcludedFlows, boolean mockConnectors, Properties startUpProperties)
    {
        this.mockInbounds = mockInbounds;
        this.mockingExcludedFlows = mockingExcludedFlows;
        this.mockConnectors = mockConnectors;
        this.startUpProperties = startUpProperties;
    }

    public List<String> getMockingExcludedFlows()
    {
        return mockingExcludedFlows;
    }

    public boolean isMockInbounds()
    {
        return mockInbounds;
    }

    public boolean isMockConnectors()
    {
        return mockConnectors;
    }

    public Properties getStartUpProperties()
    {
        return startUpProperties;
    }
}
