/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkListener;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.AnnotationsConfigurationBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.ExtensionsManagerConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.runner.MunitLoggerConfigurer;
import org.mule.munit.runner.MunitPluginFactory;
import org.mule.munit.runner.mule.context.MockingConfiguration;
import org.mule.munit.runner.mule.context.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.tck.TestingWorkListener;
import org.mule.util.ClassUtils;
import org.mule.util.TestsLogConfigurationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleContextManager {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = AnnotationsConfigurationBuilder.class.getCanonicalName();
    private MockingConfiguration configuration;
    private Collection<MunitPlugin> plugins;

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources) throws Exception {
        MuleContext context = this.createMule(resources);
        return this.startMule(context);
    }

    public MuleContext startMule(MuleContext context) throws MuleException {
        context.start();
        this.startPlugins();
        return context;
    }

    public void killMule(MuleContext muleContext) {
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
                this.stopPlugins();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (muleContext != null && !muleContext.isDisposed()) {
            muleContext.dispose();
            this.disposePlugins();
        }
        this.clearLogginConfiguration();
    }

    public MuleContext createMule(String resources) throws Exception {
        this.actionsToRunBeforeMuleContextCreation();
        this.defineLogOutput(resources);
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.getStartUpProperties()));
        builders.add((ConfigurationBuilder)new ExtensionsManagerConfigurationBuilder());
        this.addIfPresent(builders, CLASSNAME_ANNOTATIONS_CONFIG_BUILDER);
        builders.add(this.getBuilder(resources));
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContextBuilder((MuleContextBuilder)contextBuilder);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        context.getNotificationManager().setNotificationDynamic(true);
        context.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        this.plugins = new MunitPluginFactory().loadPlugins(context);
        this.initialisePlugins();
        return context;
    }

    private void actionsToRunBeforeMuleContextCreation() {
        this.setUpLogginConfiguration();
    }

    private void setUpLogginConfiguration() {
        TestsLogConfigurationHelper.configureLoggingForTest(this.getClass());
    }

    private void clearLogginConfiguration() {
        TestsLogConfigurationHelper.clearLoggingConfig();
    }

    private void addIfPresent(List<ConfigurationBuilder> builders, String builderClassName) throws Exception {
        if (ClassUtils.isClassOnPath((String)builderClassName, this.getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)builderClassName, (Object[])ClassUtils.NO_ARGS, this.getClass()));
        }
    }

    private Properties getStartUpProperties() {
        Properties properties;
        Properties properties2 = properties = this.configuration == null ? null : this.configuration.getStartUpProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("app.home") == null) {
            properties.setProperty("app.home", new File(this.getClass().getResource("/").getPath()).getAbsolutePath());
        }
        return properties;
    }

    private void defineLogOutput(String resources) throws IOException {
        String path = System.getProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY);
        if (path != null) {
            String name = resources.replace(".xml", "");
            MunitLoggerConfigurer.configureFileLogger(path, name);
        }
    }

    protected ConfigurationBuilder getBuilder(String resources) throws Exception {
        return new MunitSpringXmlConfigurationBuilder(resources, this.configuration);
    }

    protected void configureMuleContextBuilder(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    private void startPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.start();
        }
    }

    private void disposePlugins() {
        for (MunitPlugin plugin : this.plugins) {
            plugin.dispose();
        }
    }

    private void stopPlugins() throws MuleException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    private void initialisePlugins() throws InitialisationException {
        for (MunitPlugin plugin : this.plugins) {
            plugin.initialise();
        }
    }
}

