/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.result.notification;

import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;

/**
 * <p>Clases implementing this interface handle the notification of a test result. </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public interface NotificationListener
{

    void notifyRuntimeStartFailure(Notification notification);
    
    void notifyStartOf(MunitTest test);

    void notify(TestResult testResult);
    
    void notifyIgnored(TestResult testResult);

    void notifyEnd(SuiteResult result);
}
