/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.java;

import java.util.List;
import junit.framework.TestCase;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.config.MunitTestFlow;
import org.mule.tck.MuleTestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitTest
extends TestCase {
    private List<MunitFlow> before;
    MunitTestFlow flow;
    private List<MunitFlow> after;
    private MuleContext muleContext;

    public MunitTest(List<MunitFlow> before, MunitTestFlow flow, List<MunitFlow> after) {
        this.before = before;
        this.flow = flow;
        this.after = after;
        this.muleContext = flow.getMuleContext();
    }

    public String getName() {
        return this.flow.getName();
    }

    public int countTestCases() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        if (this.flow.isIgnore()) {
            return;
        }
        MuleEvent event = this.muleEvent();
        this.run(event, this.before);
        this.showDescription();
        try {
            this.flow.process(event);
        }
        catch (Throwable t) {
            if (!this.flow.expectException(t, event)) {
                throw t;
            }
        }
        finally {
            this.run(event, this.after);
        }
    }

    private void run(MuleEvent event, List<MunitFlow> flows) throws MuleException {
        if (flows != null) {
            for (MunitFlow flow : flows) {
                System.out.printf(flow.getDescription() + "%n", new Object[0]);
                flow.process(event);
            }
        }
    }

    private void showDescription() {
        System.out.printf("%nDescription:%n************%n" + this.flow.getDescription().replaceAll("\\.", "\\.%n") + "%n", new Object[0]);
    }

    protected MuleEvent muleEvent() {
        try {
            return MuleTestUtils.getTestEvent(null, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            return null;
        }
    }
}

