/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.config.MunitTestFlow;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.output.TestOutputHandler;
import org.mule.tck.MuleTestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitTest {
    private List<MunitFlow> before;
    private List<MunitFlow> after;
    private MunitTestFlow test;
    private TestOutputHandler outputHandler;

    private static String stack2string(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e2) {
            return "";
        }
    }

    public MunitTest(List<MunitFlow> before, MunitTestFlow test, List<MunitFlow> after, TestOutputHandler outputHandler) {
        this.before = before;
        this.after = after;
        this.test = test;
        this.outputHandler = outputHandler;
    }

    public String getName() {
        return this.test.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult run() {
        TestResult result = new TestResult(this.getName());
        if (this.test.isIgnore()) {
            result.setSkipped(true);
            return result;
        }
        long start = System.currentTimeMillis();
        MuleEvent event = this.muleEvent();
        try {
            this.run(event, this.before);
            this.showDescription();
            this.test.process(event);
        }
        catch (AssertionError t) {
            result.setFailure(this.buildNotifcationFrom((Throwable)((Object)t)));
        }
        catch (MuleException e) {
            try {
                if (!this.test.expectException((Throwable)e, event)) {
                    result.setError(this.buildNotifcationFrom(e));
                }
            }
            catch (AssertionError t) {
                result.setFailure(this.buildNotifcationFrom((Throwable)((Object)t)));
            }
        }
        finally {
            this.runAfter(result, event);
        }
        long end = System.currentTimeMillis();
        result.setTime(new Float(end - start).floatValue() / 1000.0f);
        return result;
    }

    private Notification buildNotifcationFrom(Throwable t) {
        return new Notification(t.getMessage(), MunitTest.stack2string(t));
    }

    private void runAfter(TestResult result, MuleEvent event) {
        try {
            this.run(event, this.after);
        }
        catch (MuleException e) {
            result.setError(this.buildNotifcationFrom(e));
        }
    }

    private void run(MuleEvent event, List<MunitFlow> flows) throws MuleException {
        if (flows != null) {
            for (MunitFlow flow : flows) {
                this.outputHandler.print(flow.getName(), flow.getDescription());
                flow.process(event);
            }
        }
    }

    private void showDescription() {
        this.outputHandler.print(this.test.getName(), this.test.getDescription());
    }

    protected MuleEvent muleEvent() {
        try {
            return MuleTestUtils.getTestEvent(null, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.test.getMuleContext());
        }
        catch (Exception e) {
            return null;
        }
    }
}

