/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.munit.config.MunitAfterSuite;
import org.mule.munit.config.MunitBeforeSuite;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.munit.runner.output.TestOutputHandler;
import org.mule.tck.MuleTestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MunitRunner<T> {
    private TestOutputHandler handler = new DefaultOutputHandler();
    private MuleContextManager muleContextManager = new MuleContextManager(null);
    private MuleContext muleContext;

    public MunitRunner(TestOutputHandler handler, MuleContextManager muleContextManager, MuleContext muleContext) {
        this.handler = handler;
        this.muleContextManager = muleContextManager;
        this.muleContext = muleContext;
    }

    protected abstract T runSuite() throws Exception;

    protected abstract String getSuiteName();

    public T run() {
        try {
            T result;
            this.handler.printTestName(this.getSuiteName());
            this.process(this.lookupFlows(MunitBeforeSuite.class), this.muleEvent());
            T t = result = this.runSuite();
            return t;
        }
        catch (Exception e) {
            this.muleContextManager.killMule(this.muleContext);
            throw new RuntimeException("Could not Run the suite", e);
        }
        finally {
            try {
                this.process(this.lookupFlows(MunitAfterSuite.class), this.muleEvent());
            }
            catch (MuleException e) {
                throw new RuntimeException("After Suite process could not be executed", e);
            }
            this.muleContextManager.killMule(this.muleContext);
        }
    }

    private MuleEvent muleEvent() {
        try {
            return MuleTestUtils.getTestEvent(null, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void process(Collection<MunitFlow> flowConstructs, MuleEvent event) throws MuleException {
        for (MunitFlow flowConstruct : flowConstructs) {
            this.handler.printDescription(flowConstruct.getName(), flowConstruct.getDescription());
            flowConstruct.process(event);
        }
    }

    private List<MunitFlow> lookupFlows(Class munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }
}

