/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule.context;

import java.io.IOException;
import org.mule.api.MuleContext;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.munit.common.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.mp.MunitMessageProcessorInterceptorFactory;
import org.mule.munit.runner.mule.context.MunitBeanDefinitionDocumentReader;
import org.mule.munit.runner.mule.context.MunitConfiguration;
import org.mule.munit.runner.mule.context.MunitXmlBeanDefinitionReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.Resource;

public class MunitApplicationContext
extends MuleApplicationContext {
    private MunitConfiguration configuration;

    public MunitApplicationContext(MuleContext muleContext, ConfigResource[] configResources, MunitConfiguration configuration) throws BeansException {
        super(muleContext, configResources);
        this.configuration = configuration;
    }

    public MunitApplicationContext(MuleContext muleContext, Resource[] springResources, MunitConfiguration configuration) throws BeansException {
        super(muleContext, springResources);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        MunitXmlBeanDefinitionReader beanDefinitionReader = new MunitXmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setDocumentReaderClass(MunitBeanDefinitionDocumentReader.class);
        beanFactory.registerBeanDefinition(MunitMessageProcessorInterceptorFactory.ID, (BeanDefinition)new RootBeanDefinition(MunitMessageProcessorInterceptorFactory.class));
        beanFactory.registerBeanDefinition(ConnectorMethodInterceptorFactory.ID, (BeanDefinition)new RootBeanDefinition(ConnectorMethodInterceptorFactory.class));
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        if (this.configuration != null) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(MunitSpringFactoryPostProcessor.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.add("mockInbounds", (Object)this.configuration.isMockInbounds());
            propertyValues.add("mockConnectors", (Object)this.configuration.isMockConnectors());
            propertyValues.add("mockingExcludedFlows", this.configuration.getMockingExcludedFlows());
            beanDefinition.setPropertyValues(propertyValues);
            beanFactory.registerBeanDefinition("___MunitSpringFactoryPostProcessor", (BeanDefinition)beanDefinition);
        }
        try {
            MunitApplicationContext.getCurrentMuleContext().set(this.getMuleContext());
            beanDefinitionReader.loadBeanDefinitions(this.getConfigResources());
        }
        finally {
            MunitApplicationContext.getCurrentMuleContext().remove();
        }
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        MunitSpringFactoryPostProcessor bean = (MunitSpringFactoryPostProcessor)beanFactory.getBean(MunitSpringFactoryPostProcessor.class);
        bean.postProcessBeanFactory(beanFactory);
    }
}

