/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.result.MunitResult;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.DummyNotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.notifiers.NotificationListenerDecorator;
import org.mule.notifiers.StreamNotificationListener;
import org.mule.notifiers.xml.XmlNotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitMojo
extends AbstractMojo {
    public static final String TARGET_SUREFIRE_REPORTS_MUNIT_TXT = "/target/surefire-reports/munit.";
    public static final String TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML = "/target/surefire-reports/TEST-munit.";
    protected MavenProject project;
    protected String munittest;
    protected boolean logToFile;
    protected List<String> classpathElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty("skipTests"))) {
            if (this.logToFile) {
                System.setProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY, this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_MUNIT_TXT + "%s-output.txt");
            }
            List testResources = this.project.getTestResources();
            for (Object o : testResources) {
                Resource testResource = (Resource)o;
                testResource.getTargetPath();
            }
            try {
                ArrayList<SuiteResult> results = new ArrayList<SuiteResult>();
                this.addUrlsToClassPath(this.makeClassPath());
                File testFolder = new File(this.project.getBasedir(), "src/test/munit");
                if (testFolder == null || !testFolder.exists()) {
                    return;
                }
                Collection allFiles = FileUtils.listFiles((File)testFolder, null, (boolean)true);
                for (File file : allFiles) {
                    String fileName = file.getPath().replace(testFolder.getPath() + File.separator, "");
                    if (!fileName.endsWith(".xml") || !this.validateFilter(fileName)) continue;
                    results.add(this.buildRunnerFor(fileName).run());
                }
                this.show(results);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void show(List<SuiteResult> results) throws MojoExecutionException {
        boolean success = true;
        System.out.println();
        System.out.println("\t=====================================");
        System.out.println("\t  Munit Summary                      ");
        System.out.println("\t=====================================");
        for (SuiteResult run : results) {
            List failingTests = run.getFailingTests();
            List errorTests = run.getErrorTests();
            System.out.println("\t >> " + FilenameUtils.getName((String)run.getTestName()) + " test result: Errors: " + errorTests.size() + ", Failures:" + failingTests.size() + ", Skipped: " + run.getNumberOfSkipped());
            this.showFailures(failingTests);
            this.showError(errorTests);
            if (failingTests.isEmpty() && errorTests.isEmpty()) continue;
            success = false;
        }
        if (!success) {
            throw new MojoExecutionException("MUnit Tests Failed!!!");
        }
    }

    private void showFailures(List<MunitResult> failingTests) {
        this.showUnsuccessfulTests(failingTests, "FAILED");
    }

    private void showError(List<MunitResult> errorTests) {
        this.showUnsuccessfulTests(errorTests, "ERROR");
    }

    private void showUnsuccessfulTests(List<MunitResult> unsuccessfulTests, String unsuccessfulTag) {
        if (!unsuccessfulTests.isEmpty()) {
            for (MunitResult result : unsuccessfulTests) {
                System.out.println("\t\t --- " + result.getTestName() + " <<< " + unsuccessfulTag);
            }
        }
    }

    private MunitSuiteRunner buildRunnerFor(String fileName) {
        MunitSuiteRunner runner = new MunitSuiteRunner(fileName);
        NotificationListenerDecorator listener = new NotificationListenerDecorator();
        listener.addNotificationListener(new StreamNotificationListener(System.out));
        listener.addNotificationListener(this.buildFileNotificationListener(fileName));
        listener.addNotificationListener(this.buildXmlNotificationListener(fileName));
        runner.setNotificationListener((NotificationListener)listener);
        return runner;
    }

    private NotificationListener buildFileNotificationListener(String fileName) {
        fileName = fileName.replace(".xml", ".txt");
        fileName = fileName.replace('/', '.');
        try {
            return new StreamNotificationListener(new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_MUNIT_TXT + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private NotificationListener buildXmlNotificationListener(String fileName) {
        fileName = fileName.replace('/', '.');
        try {
            return new XmlNotificationListener(fileName, new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private boolean validateFilter(String fileName) {
        if (this.munittest == null) {
            return true;
        }
        return fileName.matches(this.munittest);
    }

    public URLClassLoader getClassPath(List<URL> classpath) {
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }

    private void addUrlsToClassPath(List<URL> urls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private File getFile(String fullPath) throws IOException {
        File file = new File(fullPath);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            throw new IOException("Failed to create directory " + file.getParent());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Failed to create file " + file.getName());
        }
        return file;
    }
}

