/*
 * Decompiled with CFR 0.152.
 */
package org.mule.notifiers.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.notifiers.xml.CdataAwareXppDriver;
import org.mule.notifiers.xml.Property;
import org.mule.notifiers.xml.TestCase;
import org.mule.notifiers.xml.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlNotificationListener
implements NotificationListener {
    private TestSuite suite;
    private String name;
    private PrintStream out;

    public XmlNotificationListener(String name, PrintStream out) {
        this.name = name.replace(".xml", "");
        this.out = out;
        this.suite = new TestSuite(this.dumpProperties(System.getProperties()), this.name);
    }

    public void notifyStartOf(MunitTest test) {
    }

    public void notify(TestResult testResult) {
        TestCase testCase = new TestCase(testResult.getTime(), this.name, testResult.getTestName());
        testCase.setSkipped(testResult.isSkipped());
        if (testResult.getFailure() != null) {
            testCase.setFailure(testResult.getFailure().getFullMessage());
        }
        if (testResult.getError() != null) {
            testCase.setError(testResult.getError().getFullMessage());
        }
        this.suite.add(testCase);
    }

    public void notifyEnd(SuiteResult result) {
        CdataAwareXppDriver xppDriver = new CdataAwareXppDriver();
        XStream xStream = new XStream((HierarchicalStreamDriver)xppDriver);
        xStream.autodetectAnnotations(true);
        this.suite.setErrors(result.getNumberOfErrors());
        this.suite.setFailures(result.getNumberOfFailures());
        this.suite.setTests(result.getNumberOfTests());
        this.suite.setTime(result.getTime());
        this.suite.setSkipped(result.getNumberOfSkipped());
        this.out.print(xStream.toXML((Object)this.suite));
    }

    private List<Property> dumpProperties(Properties properties) {
        ArrayList<Property> testProperties = new ArrayList<Property>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            testProperties.add(new Property((String)entry.getKey(), (String)entry.getValue()));
        }
        return testProperties;
    }
}

