/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.result.MunitResult;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.DummyNotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.notifiers.NotificationListenerDecorator;
import org.mule.notifiers.StreamNotificationListener;
import org.mule.notifiers.xml.XmlNotificationListener;
import org.mule.properties.MUnitUserPropertiesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitMojo
extends AbstractMojo {
    public static final String TARGET_SUREFIRE_REPORTS_MUNIT_TXT = "/target/surefire-reports/munit.";
    public static final String TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML = "/target/surefire-reports/TEST-munit.";
    private static final String DEFAULT_APP_FOLDER = "/src/main/app/";
    private static final String DEFAULT_MUNIT_FOLDER = "/src/main/app/";
    private static final String DEFAULT_APP_PROPERTIES_RESOURCE = "mule-app.properties";
    public static final String SINGLE_TEST_NAME_TOKEN = "#";
    protected MavenProject project;
    protected String munittest;
    protected String testToRunName;
    protected boolean logToFile;
    protected Map<String, String> systemPropertyVariables;
    protected List<String> classpathElements;
    private MUnitUserPropertiesManager propertiesManager = new MUnitUserPropertiesManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty("skipTests"))) {
            this.propertiesManager.storeInitialSystemProperties();
            try {
                this.propertiesManager.addUserPropertiesToSystem(this.systemPropertyVariables);
                this.doExecute();
            }
            finally {
                this.propertiesManager.restoreInitialSystemProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws MojoExecutionException {
        if (this.logToFile) {
            System.setProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY, this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_MUNIT_TXT + "%s-output.txt");
        }
        this.stopLicenseCheck();
        this.loadAndSetApplicationProperties();
        List testResources = this.project.getTestResources();
        for (Object o : testResources) {
            Resource testResource = (Resource)o;
            testResource.getTargetPath();
        }
        try {
            ArrayList<SuiteResult> results = new ArrayList<SuiteResult>();
            this.addUrlsToClassPath(this.makeClassPath());
            File testFolder = new File(this.project.getBasedir(), "src/test/munit");
            if (testFolder == null || !testFolder.exists()) {
                return;
            }
            Collection<File> allFiles = this.getMunitTestSuiteFileList(testFolder);
            for (File file : allFiles) {
                String fileName = file.getPath().replace(testFolder.getPath() + File.separator, "");
                this.parseFilter();
                if (!fileName.endsWith(".xml") || !this.validateFilter(fileName)) continue;
                results.add(this.buildRunnerFor(fileName).run());
            }
            this.show(results);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopLicenseCheck() {
        System.setProperty("mule.testingMode", "true");
    }

    private Collection<File> getMunitTestSuiteFileList(File munitTestFolder) throws FileNotFoundException {
        ArrayList<File> munitTestSuiteFiles = new ArrayList<File>();
        Collection allFiles = FileUtils.listFiles((File)munitTestFolder, null, (boolean)true);
        for (File file : allFiles) {
            if (!this.isValidMunitTestSuiteFile(file)) continue;
            munitTestSuiteFiles.add(file);
        }
        return munitTestSuiteFiles;
    }

    private boolean isValidMunitTestSuiteFile(File file) throws FileNotFoundException {
        String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) continue;
            scanner.close();
            return true;
        }
        scanner.close();
        return false;
    }

    private void show(List<SuiteResult> results) throws MojoExecutionException {
        boolean success = true;
        System.out.println();
        System.out.println("\t=====================================");
        System.out.println("\t  Munit Summary                      ");
        System.out.println("\t=====================================");
        for (SuiteResult run : results) {
            List failingTests = run.getFailingTests();
            List errorTests = run.getErrorTests();
            System.out.println("\t >> " + FilenameUtils.getName((String)run.getTestName()) + " test result: Errors: " + errorTests.size() + ", Failures:" + failingTests.size() + ", Skipped: " + run.getNumberOfSkipped());
            this.showFailures(failingTests);
            this.showError(errorTests);
            if (failingTests.isEmpty() && errorTests.isEmpty()) continue;
            success = false;
        }
        if (!success) {
            throw new MojoExecutionException("MUnit Tests Failed!!!");
        }
    }

    private void showFailures(List<MunitResult> failingTests) {
        this.showUnsuccessfulTests(failingTests, "FAILED");
    }

    private void showError(List<MunitResult> errorTests) {
        this.showUnsuccessfulTests(errorTests, "ERROR");
    }

    private void showUnsuccessfulTests(List<MunitResult> unsuccessfulTests, String unsuccessfulTag) {
        if (!unsuccessfulTests.isEmpty()) {
            for (MunitResult result : unsuccessfulTests) {
                System.out.println("\t\t --- " + result.getTestName() + " <<< " + unsuccessfulTag);
            }
        }
    }

    private MunitSuiteRunner buildRunnerFor(String fileName) {
        MunitSuiteRunner runner = new MunitSuiteRunner(fileName, this.testToRunName);
        NotificationListenerDecorator listener = new NotificationListenerDecorator();
        listener.addNotificationListener(new StreamNotificationListener(System.out));
        listener.addNotificationListener(this.buildFileNotificationListener(fileName));
        listener.addNotificationListener(this.buildXmlNotificationListener(fileName));
        runner.setNotificationListener((NotificationListener)listener);
        return runner;
    }

    private void loadAndSetApplicationProperties() {
        String appFolderPath = this.project.getBasedir() + "/src/main/app/";
        File appPropsFile = new File(appFolderPath, DEFAULT_APP_PROPERTIES_RESOURCE);
        try {
            Map<String, String> appPropsMap = this.loadApplicationProperties(appPropsFile);
            MUnitMojo.setApplicationProperties(appPropsMap);
        }
        catch (IOException e) {
            System.out.println("mule-app.properties could not be loaded.");
        }
    }

    private Map<String, String> loadApplicationProperties(File appPropsFile) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props = this.loadPropertiesFromFile(appPropsFile.toURI().toURL());
            for (Object key : props.keySet()) {
                appPropsMap.put(key.toString(), props.getProperty(key.toString()));
            }
        }
        return appPropsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(URL url) throws IOException {
        Properties props;
        if (url == null) {
            throw new IOException("Invalid file URL!");
        }
        InputStream is = url.openStream();
        try {
            props = new Properties();
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }

    public static void setApplicationProperties(Map properties) {
        Iterator i$ = properties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = i$.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String systemProperty = key;
            System.setProperty(systemProperty, value);
        }
    }

    private NotificationListener buildFileNotificationListener(String fileName) {
        fileName = fileName.replace(".xml", ".txt");
        fileName = fileName.replace('/', '.');
        try {
            return new StreamNotificationListener(new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_MUNIT_TXT + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private NotificationListener buildXmlNotificationListener(String fileName) {
        fileName = fileName.replace('/', '.');
        try {
            return new XmlNotificationListener(fileName, new PrintStream(new FileOutputStream(this.getFile(this.project.getBasedir() + TARGET_SUREFIRE_REPORTS_TEST_MUNIT_XML + fileName))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new DummyNotificationListener();
        }
    }

    private void parseFilter() {
        if (StringUtils.isNotBlank((String)this.munittest) && this.munittest.contains(SINGLE_TEST_NAME_TOKEN)) {
            this.testToRunName = this.munittest.substring(this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN) + 1);
            this.munittest = this.munittest.substring(0, this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN));
        } else {
            this.testToRunName = "";
        }
    }

    private boolean validateFilter(String fileName) {
        if (this.munittest == null) {
            return true;
        }
        return fileName.matches(this.munittest);
    }

    public URLClassLoader getClassPath(List<URL> classpath) {
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }

    private void addUrlsToClassPath(List<URL> urls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    private File getFile(String fullPath) throws IOException {
        File file = new File(fullPath);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            throw new IOException("Failed to create directory " + file.getParent());
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Failed to create file " + file.getName());
        }
        return file;
    }
}

