/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.munit.runner.mule.MunitSuiteRunner;
import org.mule.munit.runner.mule.result.MunitResult;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.DummyNotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.notifiers.NotificationListenerDecorator;
import org.mule.notifiers.StreamNotificationListener;
import org.mule.notifiers.xml.XmlNotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUnitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String munittest;
    protected List<String> classpathElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty("skipTests"))) {
            List testResources = this.project.getTestResources();
            for (Object o : testResources) {
                Resource testResource = (Resource)o;
                testResource.getTargetPath();
            }
            try {
                ArrayList<SuiteResult> results = new ArrayList<SuiteResult>();
                this.addUrlsToClassPath(this.makeClassPath());
                File testFolder = new File(this.project.getBasedir(), "src/test/munit");
                if (testFolder == null || !testFolder.exists()) {
                    return;
                }
                for (File file : testFolder.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.endsWith(".xml") || !this.validateFilter(fileName)) continue;
                    System.out.println();
                    System.out.println("===========  Running " + fileName + " test ===========");
                    System.out.println();
                    results.add(this.buildRunnerFor(fileName).run());
                }
                this.show(results);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void show(List<SuiteResult> results) throws MojoExecutionException {
        boolean success = true;
        System.out.println();
        System.out.println("\t=====================================");
        System.out.println("\t  Munit Summary                      ");
        System.out.println("\t=====================================");
        for (SuiteResult run : results) {
            List failingTests = run.getFailingTests();
            List errorTests = run.getErrorTests();
            System.out.println("\t >> " + run.getTestName() + " test result: Errors: " + errorTests.size() + ", Failures:" + failingTests.size());
            this.showFailures(failingTests);
            this.showError(errorTests);
            if (failingTests.isEmpty() && errorTests.isEmpty()) continue;
            success = false;
        }
        if (!success) {
            throw new MojoExecutionException("MUnit Tests Failed!!!");
        }
    }

    private void showFailures(List<MunitResult> failingTests) {
        if (!failingTests.isEmpty()) {
            for (MunitResult result : failingTests) {
                System.out.println("\t\t ---" + result.getTestName() + " <<< FAILED");
            }
        }
    }

    private void showError(List<MunitResult> errorTests) {
        if (!errorTests.isEmpty()) {
            for (MunitResult result : errorTests) {
                System.out.println("\t\t ---" + result.getTestName() + " <<< ERROR");
            }
        }
    }

    private MunitSuiteRunner buildRunnerFor(String fileName) {
        MunitSuiteRunner runner = new MunitSuiteRunner(fileName);
        NotificationListenerDecorator listener = new NotificationListenerDecorator();
        listener.addNotificationListener(new StreamNotificationListener(System.out));
        listener.addNotificationListener(this.buildFileNotificationListener(fileName));
        listener.addNotificationListener(this.buildXmlNotificationListener(fileName));
        runner.setNotificationListener((NotificationListener)listener);
        return runner;
    }

    private NotificationListener buildFileNotificationListener(String fileName) {
        String name = fileName.replace(".xml", ".txt");
        try {
            return new StreamNotificationListener(new PrintStream(new FileOutputStream(new File(this.project.getBasedir() + "/target/surefire-reports/munit." + name))));
        }
        catch (FileNotFoundException e) {
            return new DummyNotificationListener();
        }
    }

    private NotificationListener buildXmlNotificationListener(String fileName) {
        try {
            return new XmlNotificationListener(fileName, new PrintStream(new FileOutputStream(new File(this.project.getBasedir() + "/target/surefire-reports/TEST-munit." + fileName))));
        }
        catch (FileNotFoundException e) {
            return new DummyNotificationListener();
        }
    }

    private boolean validateFilter(String fileName) {
        if (this.munittest == null) {
            return true;
        }
        return fileName.matches(this.munittest);
    }

    public URLClassLoader getClassPath(List<URL> classpath) {
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }

    private void addUrlsToClassPath(List<URL> urls) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader sysCl = Thread.currentThread().getContextClassLoader();
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }
}

