/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.h2.tools.RunScript;

public class DatabaseServer {
    private static Logger logger = Logger.getLogger(DatabaseServer.class);
    private String database;
    private String sqlFile;
    private String csv;
    private Connection connection;

    public DatabaseServer(String database, String sqlFile, String csv) {
        this.database = database;
        this.sqlFile = sqlFile;
        this.csv = csv;
    }

    public void start() {
        try {
            this.addJdbcToClassLoader();
            this.connection = DriverManager.getConnection("jdbc:h2:mem:" + this.database);
            this.executeQueriesFromSQLFile(this.connection);
            Statement stmt = this.connection.createStatement();
            this.createTablesFromCsv(stmt);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start the database server", e);
        }
    }

    public Object execute(String sql) {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            return statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error((Object)"There has been a problem while executing the SQL statement", (Throwable)e);
            return null;
        }
    }

    public Object executeQuery(String sql) {
        try {
            return this.getMap(sql);
        }
        catch (SQLException e) {
            logger.error((Object)"There has been a problem while executing the SQL statement", (Throwable)e);
            return null;
        }
    }

    public void validateThat(String query, String returns) {
        try {
            Writer writerQueryResult = this.getResults(query);
            Assert.assertEquals((String)writerQueryResult.toString().trim(), (String)returns.replace("\\n", "\n"));
        }
        catch (ClassCastException ccException) {
            throw new RuntimeException("The JSON String must always be an array");
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid Query");
        }
        catch (IOException e) {
            throw new RuntimeException("Could no access to query results");
        }
    }

    public void stop() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not stop the database server", e);
        }
    }

    private void addJdbcToClassLoader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName("org.h2.Driver").newInstance();
    }

    private void executeQueriesFromSQLFile(Connection conn) throws SQLException, FileNotFoundException {
        if (this.sqlFile != null) {
            InputStream streamImput = this.getClass().getResourceAsStream(File.separator + this.sqlFile);
            RunScript.execute((Connection)conn, (Reader)new InputStreamReader(streamImput));
        }
    }

    private void createTablesFromCsv(Statement stmt) {
        if (this.csv != null) {
            String[] tables;
            for (String table : tables = this.csv.split(";")) {
                String tableName = table.replaceAll(".csv", "");
                try {
                    stmt.execute("CREATE TABLE " + tableName + " AS SELECT * FROM CSVREAD('" + this.getClass().getResource("/" + table).toURI().toASCIIString() + "');");
                }
                catch (SQLException e) {
                    throw new RuntimeException("Invalid SQL, could not create table " + tableName + " from " + table);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Could not read file " + table);
                }
            }
        }
    }

    private List<Map<String, String>> getMap(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        ArrayList<Map<String, String>> jsonArray = new ArrayList<Map<String, String>>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        while (resultSet.next()) {
            HashMap<String, String> jsonObject = new HashMap<String, String>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                jsonObject.put(columnName, String.valueOf(resultSet.getObject(columnName)));
            }
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    private Writer getResults(String sql) throws SQLException, IOException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        StringWriter writer = new StringWriter();
        CSVWriter csvwriter = new CSVWriter((Writer)writer);
        csvwriter.writeAll(resultSet, true);
        return writer;
    }
}

