/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.munit.FTPServer;
import org.mule.munit.StreamKeyPairProvider;

public class SFTPServerWrapper
extends FTPServer {
    private SshServer sshd;

    @Override
    public void initialize(int port) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(port);
        StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
        this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
        SftpSubsystem.Factory factory = new SftpSubsystem.Factory();
        this.sshd.setSubsystemFactories(Arrays.asList(factory));
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshd.setShellFactory((Factory)new ProcessShellFactory());
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)new MockPasswordAuthenticator());
    }

    @Override
    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start the server", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sshd.stop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not stop the server", e);
        }
        this.sshd = null;
    }

    public class MockPasswordAuthenticator
    implements PasswordAuthenticator {
        public boolean authenticate(String s, String s1, ServerSession serverSession) {
            return true;
        }
    }
}

