/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import javax.annotation.PostConstruct;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.FTPServer;
import org.mule.munit.FTPServerWrapper;
import org.mule.munit.SFTPServerWrapper;

@Module(name="ftpserver", schemaVersion="1.0")
public class FTPServerModule {
    @Configurable
    @Optional
    @Default(value="22")
    private int port;
    @Configurable
    @Optional
    @Default(value="false")
    private boolean secure;
    private FTPServer server;

    @Processor
    public void startServer() {
        this.server.start();
    }

    @Processor
    public void containsFiles(String file, String path) {
        this.server.containsFiles(file, path);
    }

    @Processor
    public void stopServer() {
        try {
            this.server.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Processor
    public void remove(String path) {
        this.server.remove(path);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @PostConstruct
    public void buildServer() throws InitialisationException {
        this.server = this.secure ? new SFTPServerWrapper() : new FTPServerWrapper();
        this.server.initialize(this.port);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

