/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import javax.annotation.PostConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.FTPServer;
import org.mule.munit.SFTPServer;
import org.mule.munit.Server;

public class FTPServerModule {
    private int port;
    private boolean secure;
    private Server server;

    public void startServer() {
        this.server.start();
    }

    public void containsFiles(String file, String path) {
        this.server.containsFiles(file, path);
    }

    public void stopServer() {
        try {
            this.server.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void remove(String path) {
        this.server.remove(path);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @PostConstruct
    public void buildServer() throws InitialisationException {
        this.server = this.secure ? new SFTPServer() : new FTPServer();
        this.server.initialize(this.port);
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

