/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.mule.munit.MockUserManager;
import org.mule.munit.Server;

public class FTPServer
extends Server {
    private FtpServer server;

    public static Server instance(int port) {
        FTPServer ftpServer = new FTPServer();
        ftpServer.initialize(port);
        return ftpServer;
    }

    @Override
    void initialize(int port) {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(port);
        serverFactory.setUserManager((UserManager)new MockUserManager());
        serverFactory.addListener("default", factory.createListener());
        this.server = serverFactory.createServer();
    }

    @Override
    void start() {
        try {
            this.server.start();
        }
        catch (FtpException e) {
            throw new RuntimeException("Could not start FTP server", e);
        }
    }

    @Override
    void stop() {
        this.server.stop();
    }
}

