/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final ThreadLocal<DateFormat> FTP_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            df.setLenient(false);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        }
    };

    public static final String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuffer sb = new StringBuffer(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        int day = cal.get(5);
        if (day < 10) {
            sb.append(' ');
        }
        sb.append(day);
        sb.append(' ');
        long sixMonth = 15811200000L;
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > sixMonth) {
            int year = cal.get(1);
            sb.append(' ');
            sb.append(year);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm = cal.get(12);
            if (mm < 10) {
                sb.append('0');
            }
            sb.append(mm);
        }
        return sb.toString();
    }

    public static final String getISO8601Date(long millis) {
        StringBuffer sb = new StringBuffer(19);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(cal.get(1));
        sb.append('-');
        int month = cal.get(2) + 1;
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        int date = cal.get(5);
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date);
        sb.append('T');
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        int min = cal.get(12);
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min);
        sb.append(':');
        int sec = cal.get(13);
        if (sec < 10) {
            sb.append('0');
        }
        sb.append(sec);
        return sb.toString();
    }

    public static final String getFtpDate(long millis) {
        StringBuffer sb = new StringBuffer(20);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(cal.get(1));
        int month = cal.get(2) + 1;
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        int date = cal.get(5);
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date);
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        int min = cal.get(12);
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min);
        int sec = cal.get(13);
        if (sec < 10) {
            sb.append('0');
        }
        sb.append(sec);
        sb.append('.');
        int milli = cal.get(14);
        if (milli < 100) {
            sb.append('0');
        }
        if (milli < 10) {
            sb.append('0');
        }
        sb.append(milli);
        return sb.toString();
    }

    public static final Date parseFTPDate(String dateStr) throws ParseException {
        return FTP_DATE_FORMAT.get().parse(dateStr);
    }
}

