/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.context.MuleContextAware;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.munit.MunitPollManager;

public class MClient
implements MuleContextAware,
SchedulerFactoryPostProcessor {
    private MuleContext muleContext;
    private Boolean stopPollsByDefault;
    private MunitPollManager pollManager;

    public Object call(String path, Map<String, Object> parameters, Object payload, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        Object processedResponse = response = this.muleContext.getClient().send(path, payload, parameters);
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public void dispatch(String path, Map<String, Object> parameters, Object payload) throws Exception {
        this.muleContext.getClient().dispatch(path, payload, parameters);
    }

    public Object request(String url, Long timeout, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        Object processedResponse = response = this.muleContext.getClient().request(url, timeout.longValue());
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public Object send(String url, Object payload, Long timeout, Map<String, Object> messageProperties, List<NestedProcessor> responseProcessing) throws Exception {
        MuleMessage response;
        Object processedResponse = response = this.muleContext.getClient().send(url, payload, messageProperties, timeout.longValue());
        if (responseProcessing != null) {
            for (NestedProcessor processor : responseProcessing) {
                processedResponse = processor.process(processedResponse);
            }
        }
        return processedResponse;
    }

    public void schedulePoll(String ofFlow) throws Exception {
        this.pollManager.schedulePoll(ofFlow);
    }

    public Scheduler process(Object o, Scheduler scheduler) {
        if (this.stopPollsByDefault.booleanValue()) {
            return MunitPollManager.postProcessSchedulerFactory(o, scheduler);
        }
        return scheduler;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.pollManager = new MunitPollManager(context);
    }

    public void setStopPollsByDefault(Boolean stopPollsByDefault) {
        this.stopPollsByDefault = stopPollsByDefault;
    }

    public Boolean getStopPollsByDefault() {
        return this.stopPollsByDefault;
    }
}

