/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NestedProcessor;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.NestedProcessorChain;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.munit.MClient;
import org.mule.security.oauth.callback.ProcessCallback;

public class CallMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object path;
    protected String _pathType;
    protected Object parameters;
    protected Map<String, Object> _parametersType;
    protected Object payload;
    protected Object _payloadType;
    protected Object responseProcessing;
    protected List<NestedProcessor> _responseProcessingType;

    public CallMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
        if (this.responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor : (List)this.responseProcessing) {
                if (messageProcessor instanceof FlowConstructAware) {
                    ((FlowConstructAware)messageProcessor).setFlowConstruct(this.getFlowConstruct());
                }
                if (messageProcessor instanceof MuleContextAware) {
                    ((MuleContextAware)messageProcessor).setMuleContext(this.getMuleContext());
                }
                if (!(messageProcessor instanceof Initialisable)) continue;
                ((Initialisable)messageProcessor).initialise();
            }
        }
    }

    public void start() throws MuleException {
        super.start();
        if (this.responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor : (List)this.responseProcessing) {
                if (!(messageProcessor instanceof Startable)) continue;
                ((Startable)messageProcessor).start();
            }
        }
    }

    public void stop() throws MuleException {
        super.stop();
        if (this.responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor : (List)this.responseProcessing) {
                if (!(messageProcessor instanceof Stoppable)) continue;
                ((Stoppable)messageProcessor).stop();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.responseProcessing instanceof List) {
            for (MessageProcessor messageProcessor : (List)this.responseProcessing) {
                if (!(messageProcessor instanceof Disposable)) continue;
                ((Disposable)messageProcessor).dispose();
            }
        }
    }

    public void setPath(Object value) {
        this.path = value;
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    public void setResponseProcessing(Object value) {
        this.responseProcessing = value;
    }

    public void setParameters(Object value) {
        this.parameters = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedPath = (String)this.evaluateAndTransform(this.getMuleContext(), event, CallMessageProcessor.class.getDeclaredField("_pathType").getGenericType(), null, this.path);
        final Map _transformedParameters = (Map)this.evaluateAndTransform(this.getMuleContext(), event, CallMessageProcessor.class.getDeclaredField("_parametersType").getGenericType(), null, this.parameters);
        final Object _transformedPayload = this.evaluateAndTransform(this.getMuleContext(), event, CallMessageProcessor.class.getDeclaredField("_payloadType").getGenericType(), null, this.payload);
        final ArrayList<NestedProcessorChain> _transformedResponseProcessing = new ArrayList<NestedProcessorChain>();
        if (this.responseProcessing != null) {
            for (MessageProcessor messageProcessor : (List)this.responseProcessing) {
                _transformedResponseProcessing.add(new NestedProcessorChain(event, this.getMuleContext(), messageProcessor));
            }
        }
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return null;
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                return ((MClient)object).call(_transformedPath, _transformedParameters, _transformedPayload, _transformedResponseProcessing);
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(Object.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at MClient at call retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

