/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.tests.core.AbstractTest;
import org.mule.mvel2.tests.core.res.Foo;
import org.mule.mvel2.tests.core.res.KnowledgeHelperFixer;

public class CommentParsingTests
extends AbstractTest {
    private static final KnowledgeHelperFixer fixer = new KnowledgeHelperFixer();

    public void testOKQuoteComment() throws Exception {
        MVEL.compileExpression((String)"// ' this is OK!");
        MVEL.compileExpression((String)"// ' this is OK!\n");
        MVEL.compileExpression((String)"// ' this is OK!\nif(1==1) {};");
    }

    public void testOKDblQuoteComment() throws Exception {
        MVEL.compileExpression((String)"// \" this is OK!");
        MVEL.compileExpression((String)"// \" this is OK!\n");
        MVEL.compileExpression((String)"// \" this is OK!\nif(1==1) {};");
    }

    public void testIfComment() throws Exception {
        MVEL.compileExpression((String)"if(1 == 1) {\n  // Quote & Double-quote seem to break this expression\n}");
    }

    public void testIfQuoteCommentBug() throws Exception {
        MVEL.compileExpression((String)"if(1 == 1) {\n  // ' seems to break this expression\n}");
    }

    public void testIfDblQuoteCommentBug() throws Exception {
        MVEL.compileExpression((String)"if(1 == 1) {\n  // ' seems to break this expression\n}");
    }

    public void testForEachQuoteCommentBug() throws Exception {
        MVEL.compileExpression((String)"foreach ( item : 10 ) {\n  // The ' character causes issues\n}");
    }

    public void testForEachDblQuoteCommentBug() throws Exception {
        MVEL.compileExpression((String)"foreach ( item : 10 ) {\n  // The \" character causes issues\n}");
    }

    public void testForEachCommentOK() throws Exception {
        MVEL.compileExpression((String)"foreach ( item : 10 ) {\n  // The quote & double quote characters cause issues\n}");
    }

    public void testElseIfCommentBugPreCompiled() throws Exception {
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"// This is never true\nif (1==0) {\n  // Never reached\n}\n// This is always true...\nelse if (1==1) {  System.out.println('Got here!');}\n"));
    }

    public void testElseIfCommentBugEvaluated() throws Exception {
        MVEL.eval((String)"// This is never true\nif (1==0) {\n  // Never reached\n}\n// This is always true...\nelse if (1==1) {  System.out.println('Got here!');}\n");
    }

    public void testSingleLineCommentSlash() {
        String result = fixer.fix("        //System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );");
        CommentParsingTests.assertEquals((String)"        //System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testSingleLineCommentHash() {
        String result = fixer.fix("        #System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );");
        CommentParsingTests.assertEquals((String)"        #System.out.println( \"help\" );\r\n        System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testMultiLineComment() {
        String result = fixer.fix("        /*System.out.println( \"help\" );\r\n*/       System.out.println( \"help\" );  \r\n     list.add( $person );");
        CommentParsingTests.assertEquals((String)"        /*System.out.println( \"help\" );\r\n*/       System.out.println( \"help\" );  \r\n     list.add( $person );", (String)result);
    }

    public void testComments() {
        CommentParsingTests.assertEquals((Object)10, (Object)this.test("// This is a comment\n5 + 5"));
    }

    public void testComments2() {
        CommentParsingTests.assertEquals((Object)20, (Object)this.test("10 + 10; // This is a comment"));
    }

    public void testComments3() {
        CommentParsingTests.assertEquals((Object)30, (Object)this.test("/* This is a test of\r\nMVEL's support for\r\nmulti-line comments\r\n*/\r\n 15 + 15"));
    }

    public void testComments4() {
        CommentParsingTests.assertEquals((Object)50, (Object)this.test("/** This is a fun test script **/\r\na = 10;\r\n/**\r\n* Here is a useful variable\r\n*/\r\nb = 20; // set b to '20'\r\nreturn ((a + b) * 2) - 10;\r\n// last comment\n"));
    }

    public void testComments5() {
        CommentParsingTests.assertEquals((Object)"dog", (Object)this.test("foo./*Hey!*/name"));
    }

    public void testMultiLineCommentInList() {
        CommentParsingTests.assertEquals(Arrays.asList(10, 20), (Object)this.test("import " + Foo.class.getName() + ";\n [ 10, 20 /* ... */ ]"));
    }

    public void testInExpressionComment() {
        Serializable s1 = MVEL.compileExpression((String)"new String /*XXX*/(\"foo\")", (ParserContext)ParserContext.create().stronglyTyped());
        MVEL.executeExpression((Object)s1);
        Serializable s2 = MVEL.compileExpression((String)"new String/*XXX*/(\"foo\")", (ParserContext)ParserContext.create().stronglyTyped());
        MVEL.executeExpression((Object)s2);
    }

    public void testComments6() {
        String ex = "//This is an array\nlong[] arr = [ //start of array\n\t1,2, // one and two\n\t3, /*three*/\n\t4, /*four*/ 5,\n\t6, /*six*/ 7,/*seven*/ //six & seven\n\t8/*eight*/  \n\t,9,\n\t10 //ten\n]; //end of array\njava.util.Arrays.toString(arr)";
        Object o = MVEL.eval((String)ex, new HashMap());
        CommentParsingTests.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)o);
    }
}

