/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.tests.core.AbstractTest;
import org.mule.mvel2.tests.core.res.Foo;

public class ComparisonTests
extends AbstractTest {
    public void testBooleanOperator() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof == false"));
    }

    public void testBooleanOperator3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof== true"));
    }

    public void testBooleanOperator4() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof ==false"));
    }

    public void testBooleanOperator5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.woof == true"));
    }

    public void testBooleanOperator6() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("foo.bar.woof==false"));
    }

    public void testTextComparison() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.name == 'dog'"));
    }

    public void testNETextComparison() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.name != 'foo'"));
    }

    public void testChor() {
        ComparisonTests.assertEquals((Object)"cat", (Object)this.test("a or b or c"));
    }

    public void testChorWithLiteral() {
        ComparisonTests.assertEquals((Object)"fubar", (Object)this.test("a or 'fubar'"));
    }

    public void testNullCompare() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("c != null"));
    }

    public void testLessThan() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("pi < 3.15"));
        ComparisonTests.assertEquals((Object)true, (Object)this.test("pi <= 3.14"));
        ComparisonTests.assertEquals((Object)false, (Object)this.test("pi > 3.14"));
        ComparisonTests.assertEquals((Object)true, (Object)this.test("pi >= 3.14"));
    }

    public void testNegation() {
        String ex = "!fun && !fun";
        ComparisonTests.assertEquals((Object)true, (Object)this.test(ex));
    }

    public void testNegation2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("fun && !fun"));
    }

    public void testNegation3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("!(fun && fun)"));
    }

    public void testNegation4() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("(fun && fun)"));
    }

    public void testNegation5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("!false"));
    }

    public void testNegation6() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("!true"));
    }

    public void testNegation7() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("s = false; t = !s; t"));
    }

    public void testNegation8() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("s = false; t =! s; t"));
    }

    public void testRegEx() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.name ~= '[a-z].+'"));
    }

    public void testRegExNegate() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("!(foo.bar.name ~= '[a-z].+')"));
    }

    public void testRegEx2() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.name ~= '[a-z].+' && foo.bar.name != null"));
    }

    public void testRegEx3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo.bar.name~='[a-z].+'&&foo.bar.name!=null"));
    }

    public void testBlank() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("'' == empty"));
    }

    public void testBlank2() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("BWAH == empty"));
    }

    public void testBlank3() {
        ComparisonTests.assertEquals((Object)true, (Object)ComparisonTests._test("[] == empty"));
    }

    public void testBlank5() {
        ComparisonTests.assertEquals((Object)true, (Object)ComparisonTests._test("['a'] != empty"));
    }

    public void testBlank6() {
        ComparisonTests.assertEquals((Object)true, (Object)ComparisonTests._test("empty != ['a']"));
    }

    public void testBlank7() {
        ComparisonTests.assertEquals((Object)false, (Object)ComparisonTests._test("[] != empty"));
    }

    public void testBlank9() {
        ComparisonTests.assertEquals((Object)false, (Object)ComparisonTests._test("['a'] == empty"));
    }

    public void testBlank10() {
        ComparisonTests.assertEquals((Object)false, (Object)ComparisonTests._test("empty == ['a']"));
    }

    public void testInstanceCheck1() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("c is java.lang.String"));
    }

    public void testInstanceCheck2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("pi is java.lang.Integer"));
    }

    public void testInstanceCheck3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("foo is org.mule.mvel2.tests.core.res.Foo"));
    }

    public void testContains1() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("list contains 'Happy!'"));
    }

    public void testContains2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("list contains 'Foobie'"));
    }

    public void testContains3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("sentence contains 'fox'"));
    }

    public void testContains4() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("sentence contains 'mike'"));
    }

    public void testContains5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("!(sentence contains 'mike')"));
    }

    public void testContains6() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("bwahbwah = 'mikebrock'; testVar10 = 'mike'; bwahbwah contains testVar10"));
    }

    public void testContains7() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("sentence contains ('fox')"));
    }

    public void testSoundex() {
        ComparisonTests.assertTrue((boolean)((Boolean)this.test("'foobar' soundslike 'fubar'")));
    }

    public void testSoundex2() {
        ComparisonTests.assertFalse((boolean)((Boolean)this.test("'flexbar' soundslike 'fubar'")));
    }

    public void testSoundex3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("(c soundslike 'kat')"));
    }

    public void testSimilarity1() {
        ComparisonTests.assertEquals((Object)Float.valueOf(0.6666667f), (Object)this.test("c strsim 'kat'"));
    }

    public void testSoundex4() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("_xx1 = 'cat'; _xx2 = 'katt'; (_xx1 soundslike _xx2)"));
    }

    public void testSoundex5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("_type = 'fubar';_type soundslike \"foobar\""));
    }

    public void testThisReference3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("this is org.mule.mvel2.tests.core.res.Base"));
    }

    public void testThisReference4() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("this.funMap instanceof java.util.Map"));
    }

    public void testThisReference5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("this.data == 'cat'"));
    }

    public void testDateComparison() {
        ComparisonTests.assertTrue((boolean)((Boolean)this.test("dt1 < dt2")));
    }

    public void testConvertableTo() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("pi convertable_to Integer"));
    }

    public void testStringEquals() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("ipaddr == '10.1.1.2'"));
    }

    public void testCharComparison() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("'z' > 'a'"));
    }

    public void testCharComparison2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("'z' < 'a'"));
    }

    public void testJIRA100b() {
        String expression = "(8 / 10) * 100 <= 80;";
        ComparisonTests.assertEquals((Object)true, (Object)ComparisonTests.testCompiledSimple(expression, new HashMap()));
    }

    public void testJIRA92() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("'stringValue' > null"));
    }

    public void testIsDefOperator() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("_v1 = 'bar'; isdef _v1"));
    }

    public void testIsDefOperator2() {
        ComparisonTests.assertEquals((Object)false, (Object)this.test("isdef _v1"));
    }

    public void testIsDefOperator3() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("!(isdef _v1)"));
    }

    public void testIsDefOperator4() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("! (isdef _v1)"));
    }

    public void testIsDefOperator5() {
        ComparisonTests.assertEquals((Object)true, (Object)this.test("!isdef _v1"));
    }

    public void testIsDefOperator6() {
        Foo foo = new Foo();
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.eval((String)"isdef name", (Object)foo));
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"isdef name"), (Object)foo));
    }

    public void testJIRA152() {
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.eval((String)"1== -(-1)"));
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"1==-(-1)")));
    }

    public void testJIRA157() {
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.eval((String)"1 == ((byte) 1)"));
    }

    public void testJIRA181() {
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.eval((String)"0<-1"));
    }

    public void testStringCoercionForComparison() {
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.eval((String)"36 > 242"));
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.eval((String)"\"36\" > 242"));
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.eval((String)"36 > \"242\""));
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.eval((String)"\"36\" > \"242\""));
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"36 > 242", (ParserContext)parserContext)));
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"\"36\" > 242", (ParserContext)parserContext)));
        ComparisonTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"36 > \"242\"", (ParserContext)parserContext)));
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"\"36\" > \"242\"", (ParserContext)parserContext)));
        parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", String.class);
        parserContext.addInput("b", String.class);
        Serializable expression = MVEL.compileExpression((String)"a > b", (ParserContext)parserContext);
        ComparisonTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)expression, (Map)new HashMap(){
            {
                this.put("a", "36");
                this.put("b", "242");
            }
        }));
    }
}

