/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.tests.core.AbstractTest;
import org.mule.mvel2.tests.core.res.Foo;

public class InlineCollectionsTests
extends AbstractTest {
    public void testListCreation2() {
        InlineCollectionsTests.assertTrue((boolean)(this.test("[\"test\"]") instanceof List));
    }

    public void testListCreation3() {
        InlineCollectionsTests.assertTrue((boolean)(this.test("[66]") instanceof List));
    }

    public void testListCreation4() {
        List ar = (List)MVEL.eval((String)"[   66   , \"test\"   ]");
        InlineCollectionsTests.assertEquals((int)2, (int)ar.size());
        InlineCollectionsTests.assertEquals((Object)66, ar.get(0));
        InlineCollectionsTests.assertEquals((Object)"test", ar.get(1));
    }

    public void testListCreationWithCall() {
        InlineCollectionsTests.assertEquals((Object)1, (Object)this.test("[\"apple\"].size()"));
    }

    public void testArrayCreationWithLength() {
        InlineCollectionsTests.assertEquals((Object)2, (Object)this.test("Array.getLength({'foo', 'bar'})"));
    }

    public void testEmptyList() {
        InlineCollectionsTests.assertTrue((boolean)(this.test("[]") instanceof List));
    }

    public void testEmptyArray() {
        InlineCollectionsTests.assertTrue((((Object[])this.test("{}")).length == 0 ? 1 : 0) != 0);
    }

    public void testEmptyArray2() {
        Object o = MVEL.eval((String)"{     }");
        InlineCollectionsTests.assertTrue((((Object[])this.test("{    }")).length == 0 ? 1 : 0) != 0);
    }

    public void testArrayCreation() {
        InlineCollectionsTests.assertEquals((Object)0, (Object)this.test("arrayTest = {{1, 2, 3}, {2, 1, 0}}; arrayTest[1][2]"));
    }

    public void testMapCreation() {
        InlineCollectionsTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike':'sarah','tom':'jacquelin']; map['mike']"));
    }

    public void testMapCreation2() {
        InlineCollectionsTests.assertEquals((Object)"sarah", (Object)this.test("map = ['mike' :'sarah'  ,'tom'  :'jacquelin'  ]; map['mike']"));
    }

    public void testMapCreation3() {
        InlineCollectionsTests.assertEquals((Object)"foo", (Object)this.test("map = [1 : 'foo']; map[1]"));
    }

    public void testSizeOnInlineArray() {
        InlineCollectionsTests.assertEquals((Object)3, (Object)this.test("{1,2,3}.size()"));
    }

    public void testSimpleListCreation() {
        this.test("['foo', 'bar', 'foobar', 'FOOBAR']");
    }

    public void testArrayCoercion() {
        InlineCollectionsTests.assertEquals((Object)"gonk", (Object)this.test("funMethod( {'gonk', 'foo'} )"));
    }

    public void testArrayCoercion2() {
        InlineCollectionsTests.assertEquals((Object)10, (Object)this.test("sum({2,2,2,2,2})"));
    }

    public void testCompiledMapStructures() {
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"['foo':'bar'] contains 'foo'"), null, (Map)null, Boolean.class);
    }

    public void testSubListInMap() {
        InlineCollectionsTests.assertEquals((Object)"pear", (Object)this.test("map = ['test' : 'poo', 'foo' : [c, 'pear']]; map['foo'][1]"));
    }

    public void testForEach2() {
        InlineCollectionsTests.assertEquals((Object)6, (Object)this.test("total = 0; a = {1,2,3}; foreach(item : a) { total += item }; total"));
    }

    public void testForEach3() {
        InlineCollectionsTests.assertEquals((Object)true, (Object)this.test("a = {1,2,3}; foreach (i : a) { if (i == 1) { return true; } }"));
    }

    public void testForEach3a() {
        InlineCollectionsTests.assertEquals((Object)true, (Object)MVEL.eval((String)"a = {1,2,3}; foreach (i : a) { if (i == 1) { return true; } }", new HashMap()));
    }

    public void testForEach4() {
        InlineCollectionsTests.assertEquals((Object)"OneTwoThreeFour", (Object)this.test("a = {1,2,3,4}; builder = ''; foreach (i : a) { if (i == 1) { builder += 'One' } else if (i == 2) { builder += 'Two' } else if (i == 3) { builder += 'Three' } else { builder += 'Four' }}; builder;"));
    }

    public void testInlineCollectionNestedObjectCreation() {
        Map m = (Map)this.test("['Person.age' : [1, 2, 3, 4], 'Person.rating' : ['High', 'Low'], 'Person.something' : (new String('foo').toUpperCase())]");
        InlineCollectionsTests.assertEquals((Object)"FOO", m.get("Person.something"));
    }

    public void testInlineCollectionNestedObjectCreation1() {
        Map m = (Map)this.test("[new String('foo') : new String('bar')]");
        InlineCollectionsTests.assertEquals((Object)"bar", m.get("foo"));
    }

    public void testMVEL179() {
        InlineCollectionsTests.assertTrue((boolean)((Boolean)MVEL.eval((String)"(($ in [2,4,8,16,32] if $ < 10) != empty)")));
    }

    public void testInlineArrayForEach() {
        InlineCollectionsTests.assertEquals((Object)11, (Object)this.test("counterX = 0; foreach (item:{1,2,3,4,5,6,7,8,9,10}) { counterX++; }; return counterX + 1;"));
    }

    public void testInlineArrayForEach2() {
        InlineCollectionsTests.assertEquals((Object)0, (Object)this.test("counterX = 10; foreach (item:{1,1,1,1,1,1,1,1,1,1}) { counterX -= item; } return counterX;"));
    }

    public void testNegativeArraySizeBug() throws Exception {
        String expressionString1 = "results = new java.util.ArrayList(); foreach (element : elements) { if( ( {30, 214, 158, 31, 95, 223, 213, 86, 159, 34, 32, 96, 224, 160, 85, 201, 29, 157, 100, 146, 82, 203, 194, 145, 140, 81, 27, 166, 212, 38, 28, 94, 168, 23, 87, 150, 35, 149, 193, 33, 132, 206, 93, 196, 24, 88, 195, 36, 26, 154, 167, 108, 204, 74, 46, 25, 153, 202, 79, 207, 143, 43, 16, 80, 198, 208, 144, 41, 97, 142, 83, 18, 162, 103, 155, 98, 44, 17, 205, 77, 156, 141, 165, 102, 84, 37, 101, 222, 40, 104, 99, 177, 182, 22, 180, 21, 137, 221, 179, 78, 42, 178, 19, 183, 139, 218, 219, 39, 220, 20, 184, 217, 138, 62, 190, 171, 123, 113, 59, 118, 225, 124, 169, 60, 117, 1} contains element.attribute ) ) { results.add(element); } }; results";
        String expressionString2 = "results = new java.util.ArrayList(); foreach (element : elements) { if( ( {30, 214, 158, 31, 95, 223, 213, 86, 159, 34, 32, 96, 224, 160, 85, 201, 29, 157, 100, 146, 82, 203, 194, 145, 140, 81, 27, 166, 212, 38, 28, 94, 168, 23, 87, 150, 35, 149, 193, 33, 132, 206, 93, 196, 24, 88, 195, 36, 26, 154, 167, 108, 204, 74, 46, 25, 153, 202, 79, 207, 143, 43, 16, 80, 198, 208, 144, 41, 97, 142, 83, 18, 162, 103, 155, 98, 44, 17, 205, 77, 156, 141, 165, 102, 84, 37, 101, 222, 40, 104, 99, 177, 182, 22, 180, 21, 137, 221, 179, 78, 42, 178, 19, 183, 139, 218, 219, 39, 220, 20, 184, 217, 138, 62, 190, 171, 123, 113, 59, 118, 225, 124, 169, 60, 117, 1, 61, 189, 122, 68, 58, 119, 63, 226, 3, 172} contains element.attribute ) ) { results.add(element); } }; results";
        ArrayList<Target> targets = new ArrayList<Target>();
        targets.add(new Target(1));
        targets.add(new Target(999));
        HashMap<String, ArrayList<Target>> vars = new HashMap<String, ArrayList<Target>>();
        vars.put("elements", targets);
        InlineCollectionsTests.assertEquals((int)1, (int)((List)InlineCollectionsTests.testCompiledSimple(expressionString1, null, vars)).size());
        InlineCollectionsTests.assertEquals((int)1, (int)((List)InlineCollectionsTests.testCompiledSimple(expressionString2, null, vars)).size());
    }

    public void testInlineCollectionParser1() {
        InlineCollectionsTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4],'Person.rating' : 'q']")).get("Person.rating"));
        InlineCollectionsTests.assertEquals((Object)"q", ((Map)this.test("['Person.age' : [1, 2, 3, 4], 'Person.rating' : 'q']")).get("Person.rating"));
    }

    public void testParsingStability3() {
        InlineCollectionsTests.assertEquals((Object)false, (Object)this.test("!( [\"X\", \"Y\"] contains \"Y\" )"));
    }

    public void testToList() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        List list = (List)this.test(text);
        InlineCollectionsTests.assertSame((Object)"dog", list.get(0));
        InlineCollectionsTests.assertEquals((Object)"hello", list.get(1));
        InlineCollectionsTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        InlineCollectionsTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        InlineCollectionsTests.assertEquals((Object)14, nestedList.get(0));
        InlineCollectionsTests.assertEquals((Object)"car", nestedList.get(1));
        InlineCollectionsTests.assertEquals((Object)42, nestedList.get(2));
        nestedList = (List)list.get(4);
        InlineCollectionsTests.assertEquals((Object)42, nestedList.get(0));
        map = (Map)nestedList.get(1);
        InlineCollectionsTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testToListStrictMode() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        ParserContext ctx = new ParserContext();
        ctx.addInput("misc", AbstractTest.MiscTestClass.class);
        ctx.addInput("foo", Foo.class);
        ctx.addInput("c", String.class);
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        List list = (List)MVEL.executeExpression((Object)compiler.compile(ctx), (Map)InlineCollectionsTests.createTestMap());
        InlineCollectionsTests.assertSame((Object)"dog", list.get(0));
        InlineCollectionsTests.assertEquals((Object)"hello", list.get(1));
        InlineCollectionsTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        InlineCollectionsTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        InlineCollectionsTests.assertEquals((Object)14, nestedList.get(0));
        InlineCollectionsTests.assertEquals((Object)"car", nestedList.get(1));
        InlineCollectionsTests.assertEquals((Object)42, nestedList.get(2));
        nestedList = (List)list.get(4);
        InlineCollectionsTests.assertEquals((Object)42, nestedList.get(0));
        map = (Map)nestedList.get(1);
        InlineCollectionsTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testArrayAccessorAssign() {
        InlineCollectionsTests.assertEquals((Object)"foo", (Object)this.test("a = {'f00', 'bar'}; a[0] = 'foo'; a[0]"));
    }

    public void testInlineListSensitivenessToSpaces() {
        String ex = "([\"a\",\"b\", \"c\"])";
        ParserContext ctx = new ParserContext();
        Serializable s = MVEL.compileExpression((String)ex, (ParserContext)ctx);
        List result = (List)MVEL.executeExpression((Object)s, new HashMap());
        InlineCollectionsTests.assertNotNull((Object)result);
        InlineCollectionsTests.assertEquals((Object)"a", result.get(0));
        InlineCollectionsTests.assertEquals((Object)"b", result.get(1));
        InlineCollectionsTests.assertEquals((Object)"c", result.get(2));
    }

    public void testMVEL241() {
        String mvelSource = "[ 'Person.age' : [42, 43],\n'Person.sex' : ['M', 'F'] ]";
        Object eval = MVEL.eval((String)mvelSource, new HashMap());
        Map map = (Map)eval;
        InlineCollectionsTests.assertNotNull((Object)map);
        InlineCollectionsTests.assertTrue((map.size() == 2 ? 1 : 0) != 0);
        InlineCollectionsTests.assertTrue((boolean)map.containsKey("Person.age"));
        InlineCollectionsTests.assertTrue((boolean)map.containsKey("Person.sex"));
        List listSex = (List)map.get("Person.sex");
        InlineCollectionsTests.assertNotNull((Object)listSex);
        InlineCollectionsTests.assertTrue((listSex.size() == 2 ? 1 : 0) != 0);
        List listAge = (List)map.get("Person.age");
        InlineCollectionsTests.assertNotNull((Object)listAge);
        InlineCollectionsTests.assertTrue((listAge.size() == 2 ? 1 : 0) != 0);
    }

    public void testMVEL242() {
        String mvelSource = "[ 'Fact.field1' : ['val1', 'val2'], 'Fact.field2' : ['val3', 'val4'], 'Fact.field2[field1=val1]' : ['f1val1a', 'f1val1b'], 'Fact.field2[field1=val2]' : ['f1val2a', 'f1val2b'] ]";
        Object eval = MVEL.eval((String)mvelSource, new HashMap());
        Map map = (Map)eval;
        InlineCollectionsTests.assertNotNull((Object)map);
        InlineCollectionsTests.assertEquals((int)4, (int)map.size());
    }

    public void testEmptyElement() {
        Object result = MVEL.eval((String)"[2, 3, 4, ]", new HashMap());
        InlineCollectionsTests.assertTrue((boolean)(result instanceof List));
        List l = (List)result;
        InlineCollectionsTests.assertEquals((int)3, (int)l.size());
    }

    public void testAddTwoLists() {
        Object result = this.test("[1,2,3] + [4,5,6]");
        InlineCollectionsTests.assertTrue((boolean)(result instanceof List));
        List l = (List)result;
        InlineCollectionsTests.assertEquals((int)6, (int)l.size());
    }

    public void testElementToList() {
        Object result = this.test("[1,2,3] + 4");
        InlineCollectionsTests.assertTrue((boolean)(result instanceof List));
        List l = (List)result;
        InlineCollectionsTests.assertEquals((int)4, (int)l.size());
    }

    public static final class Target {
        private int _attribute;

        public Target(int attribute_) {
            this._attribute = attribute_;
        }

        public int getAttribute() {
            return this._attribute;
        }
    }
}

