/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.perftests;

import java.util.List;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.compiler.ExecutableAccessor;
import org.mule.mvel2.util.FastList;

public class InlineCollectionsPerformance {
    private static final int COUNT = 200000;

    public static void main(String[] args) {
        for (int i = 0; i < 5; ++i) {
            long time = System.currentTimeMillis();
            InlineCollectionsPerformance.testOGNLList();
            System.out.println("OGNL2.7 : " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            InlineCollectionsPerformance.testMVELList();
            System.out.println("MVEL    : " + (System.currentTimeMillis() - time));
            System.out.println();
        }
    }

    public static void testMVELList() {
        ExecutableAccessor s = (ExecutableAccessor)MVEL.compileExpression((String)"['Foo244','Bar','Foo244','Bar','Foo244','Bar','Foo244','Bar','Foo244','Bar']");
        s.getNode().getReducedValueAccelerated(null, null, null);
        for (int i = 0; i < 200000; ++i) {
            List list = (List)s.getNode().getAccessor().getValue(null, null, null);
            assert ("Foo244".equals(list.get(0)) && "Foo244".equals(list.get(2)) && list.size() == 10);
        }
    }

    public static void testOGNLList() {
    }

    public static void testJavaList() {
        for (int i = 0; i < 200000; ++i) {
            FastList list = new FastList(10);
            list.add((Object)"Foo244");
            list.add((Object)"Bar");
            list.add((Object)"Foo244");
            list.add((Object)"Bar");
            list.add((Object)"Foo244");
            list.add((Object)"Bar");
            list.add((Object)"Foo244");
            list.add((Object)"Bar");
            list.add((Object)"Foo244");
            list.add((Object)"Bar");
            assert ("Foo244".equals(list.get(0)) && "Bar".equals(list.get(1)) && list.size() == 10);
        }
    }
}

