/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import java.util.HashMap;
import java.util.HashSet;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.MVELRuntime;
import org.mule.mvel2.Macro;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.ast.WithNode;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.debug.DebugTools;
import org.mule.mvel2.debug.Debugger;
import org.mule.mvel2.debug.Frame;
import org.mule.mvel2.integration.Interceptor;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mule.mvel2.integration.impl.MapVariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.mvel2.tests.core.AbstractTest;
import org.mule.mvel2.tests.core.res.Cheese;
import org.mule.mvel2.tests.core.res.Foo;
import org.mule.mvel2.util.Make;

public class DebuggerTests
extends AbstractTest {
    private static int count;
    private static int a1;
    private static int a4;

    public void testDebuggerInvoke() {
        count = 0;
        MVELRuntime.resetDebugger();
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                if (frame.getFactory().isResolveable("a1")) {
                    a1++;
                }
                if (frame.getFactory().isResolveable("a4")) {
                    a4++;
                    System.out.println("HEI " + frame.getLineNumber());
                }
                count++;
                return 0;
            }
        });
        String src = "a1=7;\na2=8;\na3=9;\na4=10;\na5=11;\na6=12;\na7=13;\na8=14;";
        ExpressionCompiler c = new ExpressionCompiler(src);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("mysource");
        ctx.setDebugSymbols(true);
        CompiledExpression compexpr = c.compile(ctx);
        System.out.println(DebugTools.decompile((CompiledExpression)compexpr));
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)1);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)3);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)7);
        DefaultLocalVariableResolverFactory factory = new DefaultLocalVariableResolverFactory();
        MVEL.executeDebugger((CompiledExpression)compexpr, null, (VariableResolverFactory)factory);
        System.out.println(a1);
        System.out.println(a4);
        System.out.println(count);
        DebuggerTests.assertEquals((int)2, (int)a1);
        DebuggerTests.assertEquals((int)1, (int)a4);
        DebuggerTests.assertEquals((int)3, (int)count);
    }

    public void testDebuggerInvoke2() {
        count = 0;
        MVELRuntime.resetDebugger();
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                count++;
                return 0;
            }
        });
        String src = "a1=7;\na2=8;\nSystem.out.println(\"h\");\nac=23;\nde=23;\nge=23;\ngef=34;";
        ExpressionCompiler c = new ExpressionCompiler(src);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("mysource");
        ctx.setDebugSymbols(true);
        CompiledExpression compexpr = c.compile(ctx);
        System.out.println(DebugTools.decompile((CompiledExpression)compexpr));
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)1);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)2);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)3);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)4);
        MVELRuntime.registerBreakpoint((String)ctx.getSourceFile(), (int)5);
        DefaultLocalVariableResolverFactory factory = new DefaultLocalVariableResolverFactory();
        MVEL.executeDebugger((CompiledExpression)compexpr, null, (VariableResolverFactory)factory);
        System.out.println(count);
        DebuggerTests.assertEquals((int)5, (int)count);
    }

    public void testBreakpoints() {
        ExpressionCompiler compiler = new ExpressionCompiler("a = 5;\nb = 5;\n\nif (a == b) {\n\nSystem.out.println('Good');\nreturn a + b;\n}\n");
        System.out.println("-------\n" + compiler.getExpression() + "\n-------\n");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.registerBreakpoint((String)"test.mv", (int)7);
        final HashSet breaked = new HashSet();
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                breaked.add(frame.getLineNumber());
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger((Debugger)testDebugger);
        DebuggerTests.assertEquals((Object)10, (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(DebuggerTests.createTestMap())));
        DebuggerTests.assertTrue((String)"did not break at line 7", (boolean)breaked.contains(7));
    }

    public void testBreakpoints2() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println('test the debugger');\n a = 0;");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
    }

    public void testBreakpoints3() {
        String expr = "System.out.println( \"a1\" );\nSystem.out.println( \"a2\" );\nSystem.out.println( \"a3\" );\nSystem.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.addImport("System", System.class);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        String s = DebugTools.decompile((CompiledExpression)compiler.compile(context));
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        DebuggerTests.assertEquals((int)4, (int)count);
    }

    public void testBreakpointsAcrossWith() {
        String line1 = "System.out.println( \"a1\" );\n";
        String line2 = "c = new Cheese();\n";
        String line3 = "with ( c ) { type = 'cheddar',\n             price = 10 };\n";
        String line4 = "System.out.println( \"a1\" );\n";
        String expr = line1 + line2 + line3 + line4;
        System.out.println(expr);
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext context = new ParserContext();
        context.addImport("System", System.class);
        context.addImport("Cheese", Cheese.class);
        context.setStrictTypeEnforcement(true);
        context.setDebugSymbols(true);
        context.setSourceFile("mysource");
        String s = DebugTools.decompile((CompiledExpression)compiler.compile(context));
        System.out.println("output: " + s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        DebuggerTests.assertEquals((int)5, (int)count);
    }

    public void testBreakpointsAcrossComments() {
        String expression = "/** This is a comment\n *  Second comment line\n *  Third Comment Line\n */\nSystem.out.println('4');\nSystem.out.println('5');\na = 0;\nb = 1;\na + b";
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        System.out.println("Expression:\n------------");
        System.out.println(expression);
        System.out.println("------------");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)9);
        final HashSet linesEncountered = new HashSet();
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                linesEncountered.add(frame.getLineNumber());
                System.out.println("Breakpoint Encountered [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                System.out.println("vars:" + frame.getFactory().getKnownVariables());
                System.out.println("Resume Execution");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger((Debugger)testDebugger);
        DebuggerTests.assertEquals((Object)1, (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(DebuggerTests.createTestMap())));
        DebuggerTests.assertTrue((String)"Debugger did not break at line 9", (boolean)linesEncountered.contains(9));
    }

    public void testBreakpointsAcrossComments2() {
        ExpressionCompiler compiler = new ExpressionCompiler("// This is a comment\n//Second comment line\n//Third Comment Line\n\n//Test\nSystem.out.println('4');\n//System.out.println('5'); \na = 0;\nb = 1;\n a + b");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)6);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)8);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)9);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)10);
        final HashSet breaked = new HashSet();
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                breaked.add(frame.getLineNumber());
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger((Debugger)testDebugger);
        DebuggerTests.assertEquals((Object)1, (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(DebuggerTests.createTestMap())));
        DebuggerTests.assertEquals((String)"did not break at expected lines", (Object)Make.Set.$()._((Object)6)._((Object)8)._((Object)9)._((Object)10)._(), breaked);
    }

    public void testBreakpoints4() {
        String expression = "System.out.println('foo');\na = new Foo244();\nupdate (a) { name = 'bar' };\nSystem.out.println('name:' + a.name);\nreturn a.name;";
        HashMap<String, 6> interceptors = new HashMap<String, 6>();
        HashMap<String, 7> macros = new HashMap<String, 7>();
        class TestResult {
            boolean firedBefore;
            boolean firedAfter;

            TestResult() {
            }
        }
        final TestResult result = new TestResult();
        interceptors.put("Update", new Interceptor(){
            {
            }

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                System.out.println("fired update interceptor -- before");
                result.firedBefore = true;
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("fired update interceptor -- after");
                result.firedAfter = true;
                return 0;
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "@Update with";
            }
        });
        expression = MVEL.parseMacros((String)expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        ParserContext ctx = new ParserContext();
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("test2.mv");
        ctx.addImport("Foo244", Foo.class);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)3);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)4);
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)5);
        final HashSet breaked = new HashSet();
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                breaked.add(frame.getLineNumber());
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger((Debugger)testDebugger);
        DebuggerTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(DebuggerTests.createTestMap())));
        DebuggerTests.assertTrue((String)"did not fire before", (boolean)result.firedBefore);
        DebuggerTests.assertTrue((String)"did not fire after", (boolean)result.firedAfter);
        DebuggerTests.assertEquals((String)"did not break at expected points", (Object)Make.Set.$()._((Object)3)._((Object)4)._((Object)5)._(), breaked);
    }

    public void testBreakpoints5() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        String expression = "System.out.println('foo');\r\na = new Foo244();\r\na.name = 'bar';\r\nfoo.happy();\r\nSystem.out.println( 'name:' + a.name );               \r\nSystem.out.println( 'name:' + a.name );         \r\nSystem.out.println( 'name:' + a.name );     \r\nreturn a.name;";
        HashMap interceptors = new HashMap();
        HashMap macros = new HashMap();
        expression = MVEL.parseMacros((String)expression, macros);
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test2.mv");
        ctx.setDebugSymbols(true);
        ctx.addImport("Foo244", Foo.class);
        ctx.setInterceptors(interceptors);
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println("\nExpression:------------");
        System.out.println(expression);
        System.out.println("------------");
        System.out.println(DebugTools.decompile((CompiledExpression)compiled));
        MVELRuntime.registerBreakpoint((String)"test2.mv", (int)1);
        final HashSet breaked = new HashSet();
        Debugger testDebugger = new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                breaked.add(frame.getLineNumber());
                return 1;
            }
        };
        MVELRuntime.setThreadDebugger((Debugger)testDebugger);
        System.out.println("\n==RUN==\n");
        DebuggerTests.assertEquals((Object)"bar", (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(DebuggerTests.createTestMap())));
        DebuggerTests.assertTrue((String)"did not break at line 1", (boolean)breaked.contains(1));
    }

    public void testDebugSymbolsWithWindowsLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\r\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\r\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        String s = DebugTools.decompile((CompiledExpression)compiler.compile(ctx));
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        DebuggerTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithUnixLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        String s = DebugTools.decompile((CompiledExpression)compiler.compile(ctx));
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        DebuggerTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsWithMixedLinedEndings() throws Exception {
        String expr = "   System.out.println( \"a1\" );\n   System.out.println( \"a2\" );\r\n   System.out.println( \"a3\" );\n   System.out.println( \"a4\" );\r\n";
        ExpressionCompiler compiler = new ExpressionCompiler(expr);
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("mysource");
        String s = DebugTools.decompile((CompiledExpression)compiler.compile(ctx));
        System.out.println(s);
        int fromIndex = 0;
        int count = 0;
        while ((fromIndex = s.indexOf("DEBUG_SYMBOL", fromIndex + 1)) > -1) {
            ++count;
        }
        DebuggerTests.assertEquals((int)4, (int)count);
    }

    public void testDebugSymbolsSingleStatement() {
        String ex = "System.out.println( Cheese.STILTON );";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(Cheese.class);
        try {
            ExpressionCompiler compiler = new ExpressionCompiler(ex);
            CompiledExpression expr = compiler.compile(ctx);
            MVEL.executeDebugger((CompiledExpression)expr, null, (VariableResolverFactory)null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DebuggerTests.fail((String)("Should not raise exception: " + e.getMessage()));
        }
    }

    static {
        a1 = 0;
        a4 = 0;
    }
}

