/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.MapVariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.mvel2.tests.core.AbstractTest;
import org.mule.mvel2.util.CompilerTools;

public class FunctionsTest
extends AbstractTest {
    Serializable lambdaDef = MVEL.compileExpression((String)"lambda = def() {return 1;}");
    Serializable lambdaCall = MVEL.compileExpression((String)"lambda();");

    public final void testThatFunctionsCloseOverArguments() {
        Object o = MVEL.eval((String)"def fun(x) { ($ in [1, 2, 3] if $ > x) }fun(0)", new HashMap());
        FunctionsTest.assertTrue((boolean)(o instanceof List));
        FunctionsTest.assertEquals(Arrays.asList(1, 2, 3), (Object)o);
    }

    public void testFunctionDefAndCall() {
        FunctionsTest.assertEquals((Object)"FoobarFoobar", (Object)this.test("function heyFoo() { return 'Foobar'; };\nreturn heyFoo() + heyFoo();"));
    }

    public void testFunctionDefAndCall1() {
        FunctionsTest.assertEquals((Object)"FoobarFoobar", (Object)MVEL.eval((String)"function heyFoo() { return 'Foobar'; };\nreturn heyFoo() + heyFoo();", new HashMap()));
    }

    public void testFunctionDefAndCall2() {
        ExpressionCompiler compiler = new ExpressionCompiler("function heyFoo() { return 'Foobar'; };\nreturn heyFoo() + heyFoo();");
        CompiledExpression s = compiler.compile();
        Map m = CompilerTools.extractAllDeclaredFunctions((CompiledExpression)s);
        FunctionsTest.assertTrue((boolean)m.containsKey("heyFoo"));
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        FunctionsTest.assertEquals((Object)"FoobarFoobar", (Object)MVEL.executeExpression((Object)s, new HashMap()));
        FunctionsTest.assertEquals((Object)"FoobarFoobar", (Object)MVEL.executeExpression((Object)s, new HashMap()));
        OptimizerFactory.setDefaultOptimizer((String)"dynamic");
    }

    public void testFunctionDefAndCall3() {
        FunctionsTest.assertEquals((Object)"FOOBAR", (Object)this.test("function testFunction() { a = 'foo'; b = 'bar'; a + b; }; testFunction().toUpperCase();  "));
    }

    public void testFunctionDefAndCall4() {
        FunctionsTest.assertEquals((Object)"barfoo", (Object)this.test("function testFunction(input) { return input; }; testFunction('barfoo');"));
    }

    public void testFunctionDefAndCall5() {
        FunctionsTest.assertEquals((Object)10, (Object)this.test("function testFunction(x, y) { return x + y; }; testFunction(7, 3);"));
    }

    public void testFunctionDefAndCall6() {
        FunctionsTest.assertEquals((Object)"foo", (Object)MVEL.eval((String)"def fooFunction(x) x; fooFunction('foo')", new HashMap()));
    }

    public void testAnonymousFunction() {
        FunctionsTest.assertEquals((Object)"foobar", (Object)this.test("a = function { 'foobar' }; a();"));
    }

    public void testJIRA207() {
        String ex = "x = 0; y = 0;def foo() { x = 1; System.out.println('Word up'); }\ndef bar() { y = 1;  System.out.println('Peace out'); }\ndef doMany(fps) {\nforeach(f : fps) { System.out.println(f); f(); }\n}\ndoMany([foo,bar]);x == 1 && y == 1;";
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileExpression((String)ex);
        Boolean bool = (Boolean)MVEL.executeExpression((Object)s, new HashMap());
        FunctionsTest.assertTrue((boolean)bool);
        OptimizerFactory.setDefaultOptimizer((String)"dynamic");
    }

    public void testBranchesWithReturn() {
        String ex = "function max($a, $b) {\n if ($a>$b){\n    System.out.println($a);\n    return $a;\n} else {\n   System.out.println($b);\n   return $b;\n};\n}; val = max(20, 30);";
        Serializable s = MVEL.compileExpression((String)ex);
        HashMap map = new HashMap();
        MVEL.executeExpression((Object)s, map);
        FunctionsTest.assertEquals((Object)30, map.get("val"));
    }

    public void testCallGlobalStaticFunctionFromMVELFunction() {
        TestClassAZZ azz = new TestClassAZZ();
        String expr = "def foobie12345() { hey(); } foobie12345();";
        FunctionsTest.assertEquals((Object)"Heythere!", (Object)MVEL.eval((String)expr, (Object)azz, new HashMap()));
    }

    public void testDeepNestedLoopsInFunction() {
        FunctionsTest.assertEquals((Object)10, (Object)this.test("def increment(i) { i + 1 }; def ff(i) { x = 0; while (i < 1) { x++; while (i < 10) { i = increment(i); } }; if (x == 1) return i; else -1; }; i = 0; ff(i);"));
    }

    public void testFunctions5() {
        String exp = "def foo(a,b) { a + b }; foo(1.5,5.25)";
        System.out.println(MVEL.eval((String)exp, new HashMap()));
    }

    public void testJIRA174() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileExpression((String)"def test(a1) { java.util.Collection a = a1; a.clear(); a.add(1); a.add(2); a.add(3); a.remove((Object) 2); a; }\na = test(new java.util.ArrayList());\nb = test(new java.util.HashSet());");
        HashMap vars = new HashMap();
        MVEL.executeExpression((Object)s, vars);
        FunctionsTest.assertEquals((boolean)false, (boolean)((Collection)vars.get("a")).contains(2));
        FunctionsTest.assertEquals((int)2, (int)((Collection)vars.get("a")).size());
        FunctionsTest.assertEquals((boolean)false, (boolean)((Collection)vars.get("b")).contains(2));
        FunctionsTest.assertEquals((int)2, (int)((Collection)vars.get("b")).size());
    }

    public void testMVEL225() {
        Serializable compileExpression = MVEL.compileExpression((String)"def f() { int a=1;a++;return a; }; f();");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        FunctionsTest.assertEquals((Object)2, (Object)MVEL.executeExpression((Object)compileExpression, (VariableResolverFactory)factory));
    }

    public void testAnonymousFunctionDecl() {
        FunctionsTest.assertEquals((Object)3, (Object)this.test("anonFunc = function (a,b) { return a + b; }; anonFunc(1,2)"));
    }

    public void testFunctionSemantics() {
        FunctionsTest.assertEquals((Object)true, (Object)this.test("function fooFunction(a) { return a; }; x__0 = ''; 'boob' == fooFunction(x__0 = 'boob') && x__0 == 'boob';"));
    }

    public void testFunctionReuse() {
        MapVariableResolverFactory functionFactory = new MapVariableResolverFactory();
        MVEL.eval((String)"def foo() { \"foo\"; }; def bar() { \"bar\" };", (VariableResolverFactory)functionFactory);
        MapVariableResolverFactory myVarFactory = new MapVariableResolverFactory();
        myVarFactory.setNextFactory((VariableResolverFactory)functionFactory);
        Serializable s = MVEL.compileExpression((String)"foo() + bar();");
        FunctionsTest.assertEquals((Object)"foobar", (Object)MVEL.executeExpression((Object)s, (VariableResolverFactory)myVarFactory));
    }

    public void testLambda() {
        MapVariableResolverFactory functionFactory = new MapVariableResolverFactory();
        MVEL.executeExpression((Object)this.lambdaDef, (VariableResolverFactory)functionFactory);
        FunctionsTest.assertEquals((Object)1, (Object)MVEL.executeExpression((Object)this.lambdaCall, (VariableResolverFactory)functionFactory));
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"lambda = def() {return 2;}"), (VariableResolverFactory)functionFactory);
        FunctionsTest.assertEquals((Object)2, (Object)MVEL.executeExpression((Object)this.lambdaCall, (VariableResolverFactory)functionFactory));
        MVEL.executeExpression((Object)this.lambdaDef, (VariableResolverFactory)functionFactory);
        FunctionsTest.assertEquals((Object)1, (Object)MVEL.executeExpression((Object)this.lambdaCall, (VariableResolverFactory)functionFactory));
    }

    public void testConcurrentLambda() throws InterruptedException {
        int N = 20;
        int iterations = 1000;
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(20);
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        start.await();
                        for (int i = 0; i < 1000; ++i) {
                            FunctionsTest.this.testLambda();
                        }
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                    }
                    finally {
                        end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        FunctionsTest.assertEquals((String)"Test did not complete withing 10s", (boolean)true, (boolean)end.await(10L, TimeUnit.SECONDS));
        if (errors.get() > 0) {
            FunctionsTest.fail();
        }
    }

    public static class TestClassAZZ {
        public String hey() {
            return "Heythere!";
        }
    }
}

