/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.tests.core;

import junit.framework.TestCase;
import org.mule.mvel2.PropertyAccessor;
import org.mule.mvel2.tests.core.res.Base;
import org.mule.mvel2.tests.core.res.Foo;

public class PropertyAccessUnitTest
extends TestCase {
    Base base = new Base();

    public void testPropertyRead() {
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get((String)"data", (Object)this.base));
    }

    public void testDeepPropertyRead() {
        PropertyAccessUnitTest.assertEquals((Object)"dog", (Object)PropertyAccessor.get((String)"foo.bar.name", (Object)this.base));
    }

    public void testWrite() {
        PropertyAccessor.set((Object)this.base, (String)"foo.bar.name", (Object)"cat");
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get((String)"foo.bar.name", (Object)this.base));
        PropertyAccessor.set((Object)this.base, (String)"foo.bar.name", (Object)"dog");
    }

    public void testCollectionsAccess() {
        PropertyAccessor.set((Object)this.base, (String)"funMap['foo'].bar.name", (Object)"cat");
        PropertyAccessUnitTest.assertEquals((Object)"cat", (Object)PropertyAccessor.get((String)"funMap['foo'].bar.name", (Object)this.base));
    }

    public void testMethodInvoke() {
        PropertyAccessUnitTest.assertEquals((Object)"WOOF", (Object)PropertyAccessor.get((String)"foo.toUC('woof')", (Object)this.base));
    }

    public void testMethodInvoke2() {
        PropertyAccessUnitTest.assertEquals((Object)"happyBar", (Object)PropertyAccessor.get((String)"foo.happy()", (Object)this.base));
    }

    public void testMapDirect() {
        PropertyAccessUnitTest.assertTrue((boolean)(PropertyAccessor.get((String)"funMap['foo']", (Object)this.base) instanceof Foo));
    }

    public void testArrayAccess() {
        String[] a = new String[]{"foo", "bar"};
        PropertyAccessUnitTest.assertEquals((Object)"foo", (Object)PropertyAccessor.get((String)"[0]", (Object)a));
    }

    public void testArrayAccess2() {
        PropertyAccessUnitTest.assertEquals((Object)"poo", (Object)PropertyAccessor.get((String)"[0][0]", (Object)new Object[]{new String[]{"poo"}}));
    }

    public void testStaticMethodAccess() {
        PropertyAccessUnitTest.assertEquals(String.class, (Object)PropertyAccessor.get((String)"forName('java.lang.String')", Class.class));
    }
}

