/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.perftests;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.ClassImportResolverFactory;
import org.mule.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mvel2.tests.perftests.utils.EchoFunction;

public class NewObjectExpressionConcurrencyTest
extends TestCase {
    private static int NUMBER_OF_THREADS = 1000;
    private static String FUNCTION_DEFINITION = "def echo(echoMessage) {return new EchoFunction().echo(echoMessage);}";
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch latch = new CountDownLatch(NUMBER_OF_THREADS);
    private final Throwable[] exception = new Throwable[]{null};
    private final ParserContext context = new ParserContext();
    private final Object[] functionParams = new String[]{"hello"};
    private Function echoFunction;
    private CompiledExpression compilerExpression;
    private Map<String, Function> functionMap;
    private final AtomicInteger correctResults = new AtomicInteger(0);

    public void setUp() throws Exception {
        this.compilerExpression = new ExpressionCompiler(FUNCTION_DEFINITION).compile();
        this.functionMap = CompilerTools.extractAllDeclaredFunctions((CompiledExpression)this.compilerExpression);
        this.context.addImport(EchoFunction.class);
        this.echoFunction = this.functionMap.get("echo");
    }

    public void testConcurrentNewObjectExpression() throws InterruptedException {
        for (int i = 0; i < NUMBER_OF_THREADS; ++i) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        NewObjectExpressionConcurrencyTest.this.startLatch.await();
                        Object result = NewObjectExpressionConcurrencyTest.this.echoFunction.call((Object)NewObjectExpressionConcurrencyTest.this.context, null, (VariableResolverFactory)new ClassImportResolverFactory(NewObjectExpressionConcurrencyTest.this.context.getParserConfiguration(), (VariableResolverFactory)new DefaultLocalVariableResolverFactory(), true), NewObjectExpressionConcurrencyTest.this.functionParams);
                        if (result.equals(EchoFunction.ECHO + NewObjectExpressionConcurrencyTest.this.functionParams[0])) {
                            NewObjectExpressionConcurrencyTest.this.correctResults.incrementAndGet();
                        }
                    }
                    catch (Throwable t) {
                        ((NewObjectExpressionConcurrencyTest)NewObjectExpressionConcurrencyTest.this).exception[0] = t;
                    }
                    finally {
                        NewObjectExpressionConcurrencyTest.this.latch.countDown();
                    }
                }
            });
            thread.start();
        }
        this.startLatch.countDown();
        this.latch.await();
        NewObjectExpressionConcurrencyTest.assertNull((String)("Exception should be null but it was " + this.exception[0]), (Object)this.exception[0]);
        NewObjectExpressionConcurrencyTest.assertTrue((String)"Incorrect results were found", (this.correctResults.get() == NUMBER_OF_THREADS ? 1 : 0) != 0);
    }
}

