/*
 * Decompiled with CFR 0.152.
 */
package org.mule.osgi;

import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.mule.osgi.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BndMojo
extends AbstractMojo {
    private MavenProject project;
    protected ArtifactResolver resolver;
    protected ArtifactFactory artifactFactory;
    protected List remoteRepos;
    protected ArtifactRepository local;
    private ArtifactMetadataSource source;
    private Maven2OsgiConverter m_maven2OsgiConverter;
    private List<Archive> archives;
    private String versionAppend = "osgi";
    private String buildDirectoryPath;
    private Map<String, String> instructions = new HashMap<String, String>();
    private File outputDirectory;
    private File baseDir;

    public void execute() throws MojoExecutionException {
        File buildDir = new File(this.buildDirectoryPath);
        for (Archive a : this.archives) {
            try {
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", a.getClassifier());
                HashSet<Artifact> dependencies = new HashSet<Artifact>();
                this.resolver.resolveTransitively(dependencies, artifact, this.remoteRepos, this.local, this.source);
                this.resolver.resolve(artifact, this.remoteRepos, this.local);
                File artifactCopy = new File(buildDir, artifact.getFile().getName());
                artifactCopy.delete();
                FileUtils.copyFile((File)artifact.getFile(), (File)artifactCopy);
                File bundle = this.rebundle(artifactCopy, artifact, a, dependencies);
                this.attach(a, bundle, "jar", a.getClassifier());
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Could not resolve archive.", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Could not find archive.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create file.", (Exception)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MojoExecutionException("Could not rebundle.", e);
            }
            try {
                Artifact pom = this.artifactFactory.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), "pom", a.getClassifier());
                this.resolver.resolve(pom, this.remoteRepos, this.local);
                File pomCopy = new File(buildDir, pom.getFile().getName());
                pomCopy.delete();
                FileUtils.copyFile((File)pom.getFile(), (File)pomCopy);
                if (this.changeVersion(pomCopy, a.getVersion() + "-" + this.versionAppend)) {
                    this.attach(a, pomCopy, "pom", a.getClassifier());
                } else {
                    this.getLog().error((CharSequence)("Could not change artifact POM version as POM was invalid or did not exist for " + pom));
                }
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Could not resolve POM for " + a + ". Skipping."));
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().error((CharSequence)("Could not resolve POM for " + a + ". Skipping."));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create file.", (Exception)e);
            }
            try {
                Artifact sources = this.artifactFactory.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", "sources");
                this.resolver.resolve(sources, this.remoteRepos, this.local);
                if (!sources.isResolved()) {
                    return;
                }
                File sourcesCopy = new File(buildDir, sources.getFile().getName());
                sourcesCopy.delete();
                FileUtils.copyFile((File)sources.getFile(), (File)sourcesCopy);
                this.attach(a, sourcesCopy, "jar", "sources");
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Could not resolve POM for " + a + ". Skipping."));
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().error((CharSequence)("Could not resolve POM for " + a + ". Skipping."));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not create file.", (Exception)e);
            }
        }
    }

    private void attach(Archive a, File copy, String type, String classifier) {
        String version = a.getVersion() + "-" + this.versionAppend;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), version, type, classifier);
        artifact.setFile(copy);
        this.project.addAttachedArtifact(artifact);
    }

    private boolean changeVersion(File file, String newVersion) throws IOException {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read(file);
            Element version = doc.getRootElement().element("version");
            if (version == null) {
                version = doc.getRootElement().addElement("version");
            }
            version.setText(newVersion);
            XMLWriter writer = new XMLWriter();
            FileOutputStream out = new FileOutputStream(file);
            writer.setOutputStream((OutputStream)out);
            writer.write(doc);
            out.close();
            return true;
        }
        catch (DocumentException e) {
            return false;
        }
    }

    private File rebundle(File jarFile, Artifact artifact, Archive archive, HashSet<Artifact> dependencies) throws Exception {
        String failok;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultProperties(this.project));
        properties.putAll(BndMojo.transformDirectives(this.instructions, archive));
        if (archive.getInstructions() != null) {
            properties.putAll(BndMojo.transformDirectives(archive.getInstructions(), archive));
        }
        BndMojo.header(properties, "Bundle-Name", artifact.getArtifactId());
        BndMojo.header(properties, "Bundle-Version", archive.getVersion());
        File bundle = new File(jarFile.getAbsolutePath() + ".osgi");
        Builder builder = this.buildOSGiBundle(jarFile, bundle, dependencies, properties);
        List errors = builder.getErrors();
        List warnings = builder.getWarnings();
        for (String msg : warnings) {
            this.getLog().warn((CharSequence)("Warning building bundle " + artifact + " : " + msg));
        }
        for (String msg : errors) {
            this.getLog().error((CharSequence)("Error building bundle " + artifact + " : " + msg));
        }
        if (errors.size() > 0 && (null == (failok = properties.getProperty("-failok")) || "false".equalsIgnoreCase(failok))) {
            jarFile.delete();
            throw new MojoFailureException("Error(s) found in bundle configuration");
        }
        return bundle;
    }

    protected Builder buildOSGiBundle(File jarFile, File bundleFile, HashSet<Artifact> dependencies, Properties properties) throws Exception {
        Builder builder = new Builder();
        builder.setBase(new File(this.buildDirectoryPath));
        builder.setProperties(properties);
        ArrayList<Jar> cp = new ArrayList<Jar>();
        Jar jar = new Jar(jarFile);
        cp.add(jar);
        for (Artifact artifact : dependencies) {
            cp.add(new Jar(artifact.getFile()));
        }
        builder.setClasspath(cp.toArray(new Jar[0]));
        if (!properties.containsKey("Export-Package") && !properties.containsKey("Private-Package")) {
            if (properties.containsKey("-exportcontents")) {
                properties.put("Private-Package", "!*");
            } else {
                String bsn = properties.getProperty("Bundle-SymbolicName");
                String namespace = bsn.replaceAll("\\W", ".");
                properties.put("Export-Package", namespace + ".*");
            }
        }
        Jar built = builder.build();
        jar = builder.getJar();
        BndMojo.dumpManifest("BND Manifest:", jar.getManifest(), this.getLog());
        built.addAll(jar);
        built.write(bundleFile);
        builder.close();
        return builder;
    }

    protected static void dumpManifest(String title, Manifest manifest, Log log) {
        log.info((CharSequence)title);
        log.info((CharSequence)"------------------------------------------------------------------------");
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            log.info((CharSequence)(entry.getKey() + ": " + entry.getValue()));
        }
        log.info((CharSequence)"------------------------------------------------------------------------");
    }

    protected Properties getDefaultProperties(MavenProject currentProject) {
        Properties properties = new Properties();
        properties.put("Import-Package", "*");
        properties.put("-removeheaders", "Include-Resource");
        BndMojo.header(properties, "Bundle-Description", currentProject.getDescription());
        StringBuffer licenseText = BndMojo.printLicenses(currentProject.getLicenses());
        if (licenseText != null) {
            BndMojo.header(properties, "Bundle-License", licenseText);
        }
        if (currentProject.getOrganization() != null) {
            BndMojo.header(properties, "Bundle-Vendor", currentProject.getOrganization().getName());
            if (currentProject.getOrganization().getUrl() != null) {
                BndMojo.header(properties, "Bundle-DocURL", currentProject.getOrganization().getUrl());
            }
        }
        properties.putAll((Map<?, ?>)currentProject.getProperties());
        properties.putAll((Map<?, ?>)currentProject.getModel().getProperties());
        properties.putAll((Map<?, ?>)BndMojo.getProperties(currentProject.getModel(), "project.build."));
        properties.putAll((Map<?, ?>)BndMojo.getProperties(currentProject.getModel(), "pom."));
        properties.putAll((Map<?, ?>)BndMojo.getProperties(currentProject.getModel(), "project."));
        properties.put("project.baseDir", this.baseDir);
        properties.put("project.build.directory", this.buildDirectoryPath);
        properties.put("project.build.outputdirectory", this.outputDirectory);
        properties.put("classifier", "");
        return properties;
    }

    private static StringBuffer printLicenses(List licenses) {
        if (licenses == null || licenses.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (License l : licenses) {
            String url = l.getUrl();
            if (url == null) continue;
            sb.append(del);
            sb.append(url);
            del = ", ";
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }

    private static Map getProperties(Model projectModel, String prefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Method[] methods = Model.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            try {
                Object v = methods[i].invoke((Object)projectModel, null);
                if (v == null) continue;
                name = prefix + Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (v.getClass().isArray()) {
                    properties.put(name, Arrays.asList((Object[])v).toString());
                    continue;
                }
                properties.put(name, v);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return properties;
    }

    private static void header(Properties properties, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        properties.put(key, value.toString().replaceAll("[\r\n]", ""));
    }

    protected static Map<String, String> transformDirectives(Map<String, String> originalInstructions, Archive archive) {
        HashMap<String, String> transformedInstructions = new HashMap<String, String>();
        for (Map.Entry<String, String> e : originalInstructions.entrySet()) {
            String value;
            String key = e.getKey();
            if (key.startsWith("_")) {
                key = "-" + key.substring(1);
            }
            if (null == (value = e.getValue())) {
                value = "";
            } else {
                value = value.replaceAll("[\r\n]", "");
                value = value.replaceAll("\\$\\{version\\}", archive.getVersion());
            }
            transformedInstructions.put(key, value);
        }
        return transformedInstructions;
    }
}

