/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.privileged.util.AttributeEvaluator;

public final class RaiseErrorProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final String ERROR_MESSAGE = "An error occurred.";
    private AttributeEvaluator descriptionEvaluator = new AttributeEvaluator("An error occurred.", DataType.STRING);
    private String typeId;
    private ErrorType errorType;
    @Inject
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        if (StringUtils.isEmpty((String)this.typeId)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"type cannot be an empty string or null"), (Initialisable)this);
        }
        ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)this.typeId);
        this.errorType = (ErrorType)this.muleContext.getErrorTypeRepository().lookupErrorType(errorTypeComponentIdentifier).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Could not find error '%s'.", this.typeId)), (Initialisable)this));
        ExtendedExpressionManager expressionManager = this.muleContext.getExpressionManager();
        this.descriptionEvaluator.initialize(expressionManager);
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        String message = (String)this.descriptionEvaluator.resolveValue(event);
        throw new TypedException((Throwable)new DefaultMuleException(message), this.errorType);
    }

    public void setType(String type) {
        this.typeId = type;
    }

    public void setDescription(String description) {
        this.descriptionEvaluator = new AttributeEvaluator(description, DataType.STRING);
    }
}

