/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.ioc.ObjectProviderConfiguration;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.ResourceLocator;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.internal.ArtifactConfigResolverContext;
import org.mule.runtime.config.internal.ImmutableObjectProviderConfiguration;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.internal.MuleArtifactObjectProvider;
import org.mule.runtime.config.internal.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.MuleContextPostProcessor;
import org.mule.runtime.config.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.dsl.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.config.internal.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.internal.processor.ComponentLocatorCreatePostProcessor;
import org.mule.runtime.config.internal.processor.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.internal.processor.LifecycleStatePostProcessor;
import org.mule.runtime.config.internal.processor.MuleInjectorProcessor;
import org.mule.runtime.config.internal.processor.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.internal.util.ComponentBuildingDefinitionUtils;
import org.mule.runtime.config.internal.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationProcessor;
import org.mule.runtime.dsl.api.xml.parser.XmlParsingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.xml.sax.EntityResolver;

public class MuleArtifactContext
extends AbstractRefreshableConfigApplicationContext
implements ArtifactConfigResolverContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleArtifactContext.class);
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    protected final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
    private final OptionalObjectsController optionalObjectsController;
    private final Map<String, String> artifactProperties;
    private final ArtifactDeclaration artifactDeclaration;
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    private final Optional<ConfigurationProperties> parentConfigurationProperties;
    private final DefaultRegistry serviceDiscoverer;
    private final ConfigurationDependencyResolver configurationDependencyResolver;
    private final DefaultResourceLocator resourceLocator;
    protected ApplicationModel applicationModel;
    protected MuleContextWithRegistry muleContext;
    private ConfigResource[] artifactConfigResources;
    protected BeanDefinitionFactory beanDefinitionFactory;
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private ArtifactType artifactType;
    private List<ComponentIdentifier> componentNotSupportedByNewParsers = new ArrayList<ComponentIdentifier>();
    protected SpringConfigurationComponentLocator componentLocator = new SpringConfigurationComponentLocator(componentName -> {
        try {
            BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition(componentName);
            return beanDefinition.isPrototype();
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    });
    protected List<ConfigurableObjectProvider> objectProviders = new ArrayList<ConfigurableObjectProvider>();
    private Registry originalRegistry;
    private boolean disableXmlValidations;

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) throws BeansException {
        this(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, parentConfigurationProperties, artifactProperties, artifactType, pluginsClassLoaders, disableXmlValidations, runtimeComponentBuildingDefinitionProvider);
    }

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, boolean disableXmlValidations, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) {
        Preconditions.checkArgument((optionalObjectsController != null ? 1 : 0) != 0, (String)"optionalObjectsController cannot be null");
        this.muleContext = (MuleContextWithRegistry)muleContext;
        this.artifactConfigResources = artifactConfigResources;
        this.optionalObjectsController = optionalObjectsController;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.artifactDeclaration = artifactDeclaration;
        this.parentConfigurationProperties = parentConfigurationProperties;
        this.disableXmlValidations = disableXmlValidations;
        this.xmlConfigurationDocumentLoader = disableXmlValidations ? XmlConfigurationDocumentLoader.noValidationDocumentLoader() : XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader();
        this.serviceDiscoverer = new DefaultRegistry(muleContext);
        this.resourceLocator = new DefaultResourceLocator();
        this.originalRegistry = ((MuleRegistryHelper)this.muleContext.getRegistry()).getDelegate();
        runtimeComponentBuildingDefinitionProvider.getComponentBuildingDefinitions().forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)this.componentBuildingDefinitionRegistry).register(arg_0));
        ComponentBuildingDefinitionUtils.getExtensionModelsComponentBuildingDefinitions((ServiceRegistry)this.serviceRegistry, MuleArtifactContext.getExtensionModels(muleContext.getExtensionManager()).orElse(Collections.emptySet())).forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)this.componentBuildingDefinitionRegistry).register(arg_0));
        for (ClassLoader pluginArtifactClassLoader : pluginsClassLoaders) {
            ComponentBuildingDefinitionUtils.getArtifactComponentBuildingDefinitions((ServiceRegistry)this.serviceRegistry, (ClassLoader)pluginArtifactClassLoader).forEach(arg_0 -> ((ComponentBuildingDefinitionRegistry)this.componentBuildingDefinitionRegistry).register(arg_0));
        }
        this.beanDefinitionFactory = new BeanDefinitionFactory(this.componentBuildingDefinitionRegistry, muleContext.getErrorTypeRepository());
        this.createApplicationModel();
        this.validateAllConfigElementHaveParsers();
        this.configurationDependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry, componentIdentifier -> this.beanDefinitionFactory.isLanguageConstructComponent((ComponentIdentifier)componentIdentifier));
    }

    private static Optional<Set<ExtensionModel>> getExtensionModels(ExtensionManager extensionManager) {
        return Optional.ofNullable(extensionManager == null ? null : extensionManager.getExtensions());
    }

    private void validateAllConfigElementHaveParsers() {
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentIdentifier> parentIdentifierOptional = Optional.ofNullable(componentModel.getParent()).flatMap(parentComponentModel -> Optional.ofNullable(parentComponentModel.getIdentifier()));
            if (!this.beanDefinitionFactory.hasDefinition(componentModel.getIdentifier(), parentIdentifierOptional)) {
                this.componentNotSupportedByNewParsers.add(componentModel.getIdentifier());
                throw new RuntimeException(String.format("Invalid config '%s'. No definition parser found for that config", componentModel.getIdentifier()));
            }
        });
    }

    private void createApplicationModel() {
        try {
            final DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new EnvironmentPropertiesConfigurationProvider());
            new XmlConfigurationProcessor();
            List configFiles = XmlConfigurationProcessor.processXmlConfiguration((XmlParsingConfiguration)new XmlParsingConfiguration(){

                public ParsingPropertyResolver getParsingPropertyResolver() {
                    return propertyKey -> (String)propertyResolver.resolveValue(propertyKey);
                }

                public ConfigResource[] getArtifactConfigResources() {
                    return MuleArtifactContext.this.getArtifactConfigResources();
                }

                public ResourceLocator getResourceLocator() {
                    return MuleArtifactContext.this.resourceLocator;
                }

                public Supplier<SAXParserFactory> getSaxParserFactory() {
                    return () -> XMLSecureFactories.createDefault().getSAXParserFactory();
                }

                public XmlConfigurationDocumentLoader getXmlConfigurationDocumentLoader() {
                    return MuleArtifactContext.this.xmlConfigurationDocumentLoader;
                }

                public EntityResolver getEntityResolver() {
                    return new ModuleDelegatingEntityResolver(MuleArtifactContext.this.getExtensions());
                }

                public List<XmlNamespaceInfoProvider> getXmlNamespaceInfoProvider() {
                    return XmlNamespaceInfoProviderSupplier.createFromExtensionModels(MuleArtifactContext.this.getExtensions(), Optional.of(cl -> MuleArtifactContext.this.serviceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, cl).stream().collect(Collectors.toList())));
                }
            });
            ArtifactConfig artifactConfig = new ArtifactConfig.Builder().setApplicationName(this.getArtifactName()).addConfigFiles((Collection)configFiles).build();
            Set extensions = this.muleContext.getExtensionManager() != null ? this.muleContext.getExtensionManager().getExtensions() : Collections.emptySet();
            ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(this.muleContext.getExecutionClassLoader());
            this.applicationModel = new ApplicationModel(artifactConfig, this.artifactDeclaration, extensions, this.artifactProperties, this.parentConfigurationProperties, Optional.of(this.componentBuildingDefinitionRegistry), true, (ResourceProvider)externalResourceProvider);
        }
        catch (MuleRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected void prepareRefresh() {
        super.prepareRefresh();
        this.registerErrorTypes();
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.registerEditors(beanFactory);
        this.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory, beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor((MuleContext)this.muleContext), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState()), new ComponentLocatorCreatePostProcessor(this.componentLocator)});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
        this.prepareObjectProviders();
    }

    protected void prepareObjectProviders() {
        MuleArtifactObjectProvider muleArtifactObjectProvider = new MuleArtifactObjectProvider(this);
        ImmutableObjectProviderConfiguration providerConfiguration = new ImmutableObjectProviderConfiguration(this.applicationModel.getConfigurationProperties(), (ObjectProvider)muleArtifactObjectProvider);
        for (ConfigurableObjectProvider objectProvider : this.objectProviders) {
            objectProvider.configure((ObjectProviderConfiguration)providerConfiguration);
        }
    }

    protected void registerObjectFromObjectProviders(ConfigurableListableBeanFactory beanFactory) {
        ((ObjectProviderAwareBeanFactory)beanFactory).setObjectProviders(this.objectProviders);
    }

    private List<Pair<ComponentModel, Optional<String>>> lookObjectProvidersComponentModels(ApplicationModel applicationModel) {
        ArrayList<Pair<ComponentModel, Optional<String>>> objectProviders = new ArrayList<Pair<ComponentModel, Optional<String>>>();
        applicationModel.executeOnEveryRootElement(componentModel -> {
            if (componentModel.isEnabled() && componentModel.getType() != null && ConfigurableObjectProvider.class.isAssignableFrom(componentModel.getType())) {
                objectProviders.add(new Pair(componentModel, Optional.ofNullable(componentModel.getNameAttribute())));
            }
        });
        return objectProviders;
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext((MuleContext)this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    protected void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    public void close() {
        if (this.isRunning()) {
            super.close();
            this.applicationModel.close();
        }
    }

    public static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray((InputStream)resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.createApplicationComponents(beanFactory, this.applicationModel, true);
    }

    private void registerErrorTypes() {
        HashSet syntheticErrorNamespaces = new HashSet();
        this.applicationModel.executeOnEveryMuleComponentTree(cm -> {
            SpringComponentModel componentModel = (SpringComponentModel)cm;
            this.resolveErrorTypes(componentModel, syntheticErrorNamespaces);
        });
    }

    private void resolveErrorTypes(SpringComponentModel componentModel, Set<String> syntheticErrorNamespaces) {
        List innerComponents = componentModel.getInnerComponents();
        if (!innerComponents.isEmpty()) {
            for (ComponentModel innerComponent : innerComponents) {
                this.processRaiseError(innerComponent, syntheticErrorNamespaces);
                this.resolveErrorTypes((SpringComponentModel)innerComponent, syntheticErrorNamespaces);
            }
        }
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).ifPresent(componentBuildingDefinition -> this.registerErrorMappings(componentModel, syntheticErrorNamespaces));
    }

    private void registerErrorMappings(SpringComponentModel componentModel, Set<String> syntheticErrorNamespaces) {
        List errorMappingComponents = componentModel.getInnerComponents().stream().filter(innerComponent -> ApplicationModel.ERROR_MAPPING_IDENTIFIER.equals(innerComponent.getIdentifier())).collect(Collectors.toList());
        if (!errorMappingComponents.isEmpty()) {
            errorMappingComponents.stream().forEach(innerComponent -> {
                ComponentIdentifier source;
                Map parameters = innerComponent.getParameters();
                ComponentIdentifier componentIdentifier = source = parameters.containsKey("sourceType") ? ComponentIdentifier.buildFromStringRepresentation((String)((String)parameters.get("sourceType"))) : Errors.ComponentIdentifiers.Handleable.ANY;
                if (!this.muleContext.getErrorTypeRepository().lookupErrorType(source).isPresent()) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find error '%s'.", (Object[])new Object[]{source}));
                }
                this.resolveErrorType((String)parameters.get("targetType"), syntheticErrorNamespaces, !this.disableXmlValidations);
            });
        }
    }

    private void processRaiseError(ComponentModel componentModel, Set<String> syntheticErrorNamespaces) {
        if (componentModel.getIdentifier().equals(CoreDslConstants.RAISE_ERROR_IDENTIFIER)) {
            String representation = (String)componentModel.getParameters().get("type");
            if (StringUtils.isEmpty((String)representation) && this.disableXmlValidations) {
                return;
            }
            this.resolveErrorType(representation, syntheticErrorNamespaces, !this.disableXmlValidations);
        }
    }

    private ErrorType resolveErrorType(String representation, Set<String> syntheticErrorNamespaces, boolean checkErrorTypes) {
        ComponentIdentifier errorIdentifier = BeanDefinitionFactory.parserErrorType(representation);
        String namespace = errorIdentifier.getNamespace();
        String identifier = errorIdentifier.getName();
        ErrorTypeRepository errorTypeRepository = this.muleContext.getErrorTypeRepository();
        Optional optionalErrorType = errorTypeRepository.lookupErrorType(errorIdentifier);
        if (BeanDefinitionFactory.CORE_ERROR_NS.equals(namespace)) {
            if (checkErrorTypes) {
                return (ErrorType)optionalErrorType.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("There's no MULE error named '%s'.", identifier))));
            }
            return optionalErrorType.orElse(null);
        }
        if (errorTypeRepository.getErrorNamespaces().contains(namespace) && !syntheticErrorNamespaces.contains(namespace)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Cannot use error type '%s:%s': namespace already exists.", namespace, identifier)));
        }
        if (syntheticErrorNamespaces.contains(namespace)) {
            if (optionalErrorType.isPresent()) {
                return (ErrorType)optionalErrorType.get();
            }
        } else {
            syntheticErrorNamespaces.add(namespace);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Registering errorType '%s'", errorIdentifier));
        }
        return errorTypeRepository.addErrorType(errorIdentifier, errorTypeRepository.getAnyErrorType());
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Exception e) {
            for (ObjectProvider objectProvider : this.objectProviders) {
                LifecycleUtils.disposeIfNeeded((Object)objectProvider, (Logger)LOGGER);
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected List<String> createApplicationComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        List<Pair<ComponentModel, Optional<String>>> objectProvidersByName = this.lookObjectProvidersComponentModels(applicationModel);
        HashSet alwaysEnabledTopLevelComponents = new HashSet();
        HashSet alwaysEnabledUnnamedTopLevelComponents = new HashSet();
        HashSet alwaysEnabledGeneratedTopLevelComponentsName = new HashSet();
        this.configurationDependencyResolver.resolveAlwaysEnabledComponents().forEach(dependencyNode -> {
            if (dependencyNode.isTopLevel()) {
                alwaysEnabledTopLevelComponents.add(dependencyNode.getComponentName());
            } else if (dependencyNode.isUnnamedTopLevel() && dependencyNode.getComponentIdentifier().isPresent()) {
                alwaysEnabledUnnamedTopLevelComponents.add(dependencyNode.getComponentIdentifier().get());
            }
        });
        ArrayList<String> createdComponentModels = new ArrayList<String>();
        applicationModel.executeOnEveryMuleComponentTree(cm -> {
            SpringComponentModel componentModel = (SpringComponentModel)cm;
            if (!mustBeRoot || componentModel.isRoot()) {
                SpringComponentModel parentComponentModel;
                if (this.beanDefinitionFactory.isComponentIgnored(componentModel.getIdentifier())) {
                    return;
                }
                SpringComponentModel springComponentModel = parentComponentModel = componentModel.getParent() != null ? (SpringComponentModel)componentModel.getParent() : (SpringComponentModel)applicationModel.getRootComponentModel();
                if (componentModel.isEnabled() || alwaysEnabledUnnamedTopLevelComponents.contains(componentModel.getIdentifier())) {
                    if (componentModel.getNameAttribute() != null && componentModel.isRoot()) {
                        createdComponentModels.add(componentModel.getNameAttribute());
                    }
                    this.beanDefinitionFactory.resolveComponentRecursively(parentComponentModel, componentModel, (BeanDefinitionRegistry)beanFactory, (resolvedComponentModel, registry) -> {
                        SpringComponentModel resolvedSpringComponentModel = (SpringComponentModel)resolvedComponentModel;
                        if (resolvedComponentModel.isRoot()) {
                            String nameAttribute = resolvedComponentModel.getNameAttribute();
                            if (resolvedComponentModel.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
                                nameAttribute = "_muleConfiguration";
                            } else if (nameAttribute == null) {
                                nameAttribute = AutoIdUtils.uniqueValue((String)resolvedSpringComponentModel.getBeanDefinition().getBeanClassName());
                                if (alwaysEnabledUnnamedTopLevelComponents.contains(resolvedSpringComponentModel.getIdentifier())) {
                                    alwaysEnabledGeneratedTopLevelComponentsName.add(nameAttribute);
                                    createdComponentModels.add(nameAttribute);
                                }
                            }
                            registry.registerBeanDefinition(nameAttribute, resolvedSpringComponentModel.getBeanDefinition());
                            MuleArtifactContext.postProcessBeanDefinition(componentModel, registry, nameAttribute);
                        }
                    }, null, this.componentLocator);
                } else {
                    this.beanDefinitionFactory.resolveComponentRecursively(parentComponentModel, componentModel, (BeanDefinitionRegistry)beanFactory, null, null, this.componentLocator);
                }
                this.componentLocator.addComponentLocation((ComponentLocation)cm.getComponentLocation());
            }
        });
        this.objectProviders.addAll(objectProvidersByName.stream().map(pair -> (ConfigurableObjectProvider)((ComponentModel)pair.getFirst()).getObjectInstance()).collect(Collectors.toList()));
        this.registerObjectFromObjectProviders((ConfigurableListableBeanFactory)beanFactory);
        Set objectProviderNames = objectProvidersByName.stream().map(Pair::getSecond).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        createdComponentModels.sort(Comparator.comparing(beanName -> {
            if (objectProviderNames.contains(beanName)) {
                return 1;
            }
            if (alwaysEnabledGeneratedTopLevelComponentsName.contains(beanName)) {
                return 2;
            }
            if (alwaysEnabledTopLevelComponents.contains(beanName)) {
                return 3;
            }
            return 4;
        }));
        return createdComponentModels;
    }

    public ConfigurationDependencyResolver getDependencyResolver() {
        return this.configurationDependencyResolver;
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new SpringMuleContextServiceConfigurator((MuleContext)this.muleContext, this.applicationModel.getConfigurationProperties(), this.artifactType, this.optionalObjectsController, (BeanDefinitionRegistry)beanFactory, this.componentLocator, (org.mule.runtime.api.artifact.Registry)this.serviceDiscoverer, this.originalRegistry, (ResourceLocator)this.resourceLocator).createArtifactServices();
        this.originalRegistry = null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Optional configurationOptional = this.applicationModel.findComponentDefinitionModels(CoreDslConstants.CONFIGURATION_IDENTIFIER).stream().findFirst();
        if (configurationOptional.isPresent()) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, null);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, null);
        this.registerInjectorProcessor(beanFactory);
    }

    protected void registerInjectorProcessor(ConfigurableListableBeanFactory beanFactory) {
        MuleInjectorProcessor muleInjectorProcessor = null;
        if (this.artifactType.equals((Object)ArtifactType.APP) || this.artifactType.equals((Object)ArtifactType.POLICY) || this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            muleInjectorProcessor = new MuleInjectorProcessor();
        }
        if (muleInjectorProcessor != null) {
            muleInjectorProcessor.setBeanFactory((BeanFactory)beanFactory);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)muleInjectorProcessor);
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy((InstantiationStrategy)new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(SpringComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", (BeanDefinition)converterBeanDefinitionCopy);
        }
    }

    public MuleContextWithRegistry getMuleContext() {
        return this.muleContext;
    }

    public OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public synchronized void getPrototypeBeanWithRootContainer(String name, String rootContainerName) {
        BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition(name);
        Preconditions.checkState((boolean)beanDefinition.isPrototype(), (String)String.format("Bean with name %s is not a prototype", name));
        this.updateBeanDefinitionRootContainerName(rootContainerName, beanDefinition);
    }

    private void updateBeanDefinitionRootContainerName(String rootContainerName, BeanDefinition beanDefinition) {
        Class<?> beanClass = null;
        try {
            beanClass = Thread.currentThread().getContextClassLoader().loadClass(beanDefinition.getBeanClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (beanClass == null || Component.class.isAssignableFrom(beanClass)) {
            ComponentModelHelper.updateAnnotationValue((QName)AbstractComponent.ROOT_CONTAINER_NAME_KEY, (Object)rootContainerName, (BeanDefinition)beanDefinition);
        }
        for (PropertyValue propertyValue : beanDefinition.getPropertyValues().getPropertyValueList()) {
            Object value = propertyValue.getValue();
            this.processBeanValue(rootContainerName, value);
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : beanDefinition.getConstructorArgumentValues().getGenericArgumentValues()) {
            this.processBeanValue(rootContainerName, valueHolder.getValue());
        }
    }

    private void processBeanValue(String rootContainerName, Object value) {
        if (value instanceof BeanDefinition) {
            this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)value);
        } else if (value instanceof ManagedList) {
            ManagedList managedList = (ManagedList)value;
            for (int i = 0; i < managedList.size(); ++i) {
                Object itemValue = managedList.get(i);
                if (!(itemValue instanceof BeanDefinition)) continue;
                this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)itemValue);
            }
        } else if (value instanceof ManagedMap) {
            ManagedMap managedMap = (ManagedMap)value;
            managedMap.forEach((key, mapValue) -> this.processBeanValue(rootContainerName, mapValue));
        }
    }

    public org.mule.runtime.api.artifact.Registry getRegistry() {
        return (org.mule.runtime.api.artifact.Registry)this.getMuleContext().getRegistry().get("_muleRegistry");
    }

    public String toString() {
        return String.format("%s: %s (%s)", ((Object)((Object)this)).getClass().getName(), this.muleContext.getConfiguration().getId(), this.artifactType.name());
    }

    public String getArtifactName() {
        return this.muleContext.getConfiguration().getId();
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }

    public ConfigResource[] getArtifactConfigResources() {
        return this.artifactConfigResources;
    }

    public Set<ExtensionModel> getExtensions() {
        return this.muleContext.getExtensionManager() == null ? Collections.emptySet() : this.muleContext.getExtensionManager().getExtensions();
    }

    public ClassLoader getExecutionClassLoader() {
        return this.muleContext.getExecutionClassLoader();
    }
}

