/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherRepositoryState;
import org.mule.maven.client.internal.AetherRepositoryStateFactory;
import org.mule.maven.client.internal.AetherResolutionContext;
import org.mule.maven.client.internal.BundleDependencyHelper;
import org.mule.maven.client.internal.DefaultModelCache;
import org.mule.maven.client.internal.DefaultPomFileSupplierFactory;
import org.mule.maven.client.internal.DefaultVersionRangeResult;
import org.mule.maven.client.internal.RemoteRepositoryModelResolver;
import org.mule.maven.client.internal.pom.UrlModelSource;
import org.mule.maven.client.internal.util.MavenModelUtils;
import org.mule.maven.client.internal.util.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherMavenClient
implements MavenClient {
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    public static final String MULE_DOMAIN_CLASSIFIER = "mule-domain";
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherMavenClient.class);
    private static final String POM = "pom";
    private static final String POM_XML = "pom.xml";
    private static final String ANY = "*";
    private PomFileSupplierFactory pomFileSupplierFactory = new DefaultPomFileSupplierFactory();
    private MavenConfiguration mavenConfiguration;
    private AetherResolutionContext aetherResolutionContext;
    private Optional<Consumer<DefaultRepositorySystemSession>> sessionConfigurator = Optional.empty();

    public AetherMavenClient(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        this.aetherResolutionContext = new AetherResolutionContext(mavenConfiguration);
    }

    private AetherRepositoryState getRepositoryState(File localRepositoryLocation, Optional<WorkspaceReader> workspaceReader) {
        return AetherRepositoryStateFactory.newAetherRepositoryState(localRepositoryLocation, this.aetherResolutionContext, this.mavenConfiguration, this.sessionConfigurator, workspaceReader);
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public void setSessionConfigurator(Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.sessionConfigurator = Optional.of(sessionConfigurator);
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        return this.resolveArtifactDependencies(artifactFile, includeTestDependencies, includeProvidedDependencies, localRepositoryLocationSupplier, Optional.empty(), temporaryFolder);
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver, Optional<File> temporaryFolder) {
        try {
            List<Object> remoteRepositories;
            List<Dependency> managedDependencies;
            File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.aetherResolutionContext.getLocalRepositoryLocation());
            AetherRepositoryState repositoryState = this.getRepositoryState(localRepositoryLocation, Optional.empty());
            Model model = this.getEffectiveModel(artifactFile, temporaryFolder, Optional.of(repositoryState));
            if (model.getProfiles().stream().map(Profile::getActivation).filter(Objects::nonNull).anyMatch(activation -> activation.getFile() != null)) {
                throw new UnsupportedOperationException(String.format("Error while resolving dependencies for %s due to profiles activation by file are not supported", model.getId()));
            }
            DefaultArtifact artifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, POM, model.getVersion());
            mavenReactorResolver.ifPresent(reactor -> repositoryState.setWorkspaceReader(new MavenWorkspaceReaderAdapter((MavenReactorResolver)reactor)));
            List<Dependency> dependencies = model.getDependencies().stream().map(modelDependency -> AetherMavenClient.convertModelDependency(modelDependency, repositoryState.getSession().getArtifactTypeRegistry())).collect(Collectors.toList());
            List<Object> list = managedDependencies = model.getDependencyManagement() == null ? Collections.emptyList() : model.getDependencyManagement().getDependencies().stream().map(modelDependency -> AetherMavenClient.convertModelDependency(modelDependency, repositoryState.getSession().getArtifactTypeRegistry())).collect(Collectors.toList());
            if (!this.mavenConfiguration.getIgnoreArtifactDescriptorRepositories()) {
                remoteRepositories = model.getRepositories() == null ? Collections.emptyList() : model.getRepositories().stream().map(modelRepository -> MavenModelUtils.convertModelRepository((Repository)modelRepository)).collect(Collectors.toList());
                remoteRepositories = new RemoteRepositoryModelResolver(repositoryState.getRemoteRepositoryManager(), (RepositorySystemSession)repositoryState.getSession()).resolveRepositories(this.aetherResolutionContext.getRemoteRepositoriesWithoutSuperPomModelRepositories(), remoteRepositories);
            } else {
                remoteRepositories = this.aetherResolutionContext.getRemoteRepositories();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("About to fetch required dependencies for artifact: {}. This may take a while...", (Object)ArtifactIdUtils.toId((Artifact)artifact));
            }
            return this.resolveDependencies(dependencies, managedDependencies, remoteRepositories, includeTestDependencies, includeProvidedDependencies, repositoryState);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
    }

    public List<BundleDependency> resolveArtifactDependencies(List<BundleDescriptor> dependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver) {
        try {
            File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.aetherResolutionContext.getLocalRepositoryLocation());
            AetherRepositoryState repositoryState = this.getRepositoryState(localRepositoryLocation, Optional.empty());
            mavenReactorResolver.ifPresent(reactor -> repositoryState.setWorkspaceReader(new MavenWorkspaceReaderAdapter((MavenReactorResolver)reactor)));
            List<Dependency> dependenciesToResolve = dependencies.stream().map(bundleDescriptor -> new Dependency((Artifact)new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion()), null)).collect(Collectors.toList());
            return this.resolveDependencies(dependenciesToResolve, Collections.emptyList(), this.aetherResolutionContext.getRemoteRepositories(), false, false, repositoryState);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException("There was an issue solving the dependencies", e);
        }
    }

    public Model getEffectiveModel(File artifactFile, Optional<File> temporaryFolder, Optional<AetherRepositoryState> repositoryStateOptional) {
        Model model;
        try {
            AetherRepositoryState repositoryState = repositoryStateOptional.orElseGet(() -> this.getRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty()));
            DefaultModelBuildingRequest defaultModelBuildingRequest = new DefaultModelBuildingRequest();
            this.setPom((ModelBuildingRequest)defaultModelBuildingRequest, artifactFile, temporaryFolder);
            this.mavenConfiguration.getUserProperties().ifPresent(properties -> defaultModelBuildingRequest.setUserProperties(properties));
            this.mavenConfiguration.getActiveProfiles().ifPresent(profiles -> defaultModelBuildingRequest.setActiveProfileIds(profiles));
            this.mavenConfiguration.getInactiveProfiles().ifPresent(profiles -> defaultModelBuildingRequest.setInactiveProfileIds(profiles));
            defaultModelBuildingRequest.setTwoPhaseBuilding(false);
            defaultModelBuildingRequest.setProcessPlugins(false);
            defaultModelBuildingRequest.setModelCache(DefaultModelCache.newInstance((RepositorySystemSession)repositoryState.getSession()));
            defaultModelBuildingRequest.setModelResolver(repositoryState.createModelResolver(this.aetherResolutionContext.getRemoteRepositories()));
            defaultModelBuildingRequest.setSystemProperties(System.getProperties());
            defaultModelBuildingRequest.setValidationLevel(0);
            model = new DefaultModelBuilderFactory().newInstance().build((ModelBuildingRequest)defaultModelBuildingRequest).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException(e);
        }
        return model;
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, BundleDescriptor bundleDescriptor) {
        return this.resolveBundleDescriptorDependencies(includeTestDependencies, false, bundleDescriptor);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
        try {
            AetherRepositoryState repositoryState = this.getRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactDescriptorResult artifactDescriptorResult = repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)repositoryState.getSession(), new ArtifactDescriptorRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null));
            List remoteRepositories = this.mavenConfiguration.getIgnoreArtifactDescriptorRepositories() ? this.aetherResolutionContext.getRemoteRepositories() : new RemoteRepositoryModelResolver(repositoryState.getRemoteRepositoryManager(), (RepositorySystemSession)repositoryState.getSession()).resolveRepositories(this.aetherResolutionContext.getRemoteRepositoriesWithoutSuperPomModelRepositories(), artifactDescriptorResult.getRepositories());
            return this.resolveDependencies(artifactDescriptorResult.getDependencies(), artifactDescriptorResult.getManagedDependencies(), remoteRepositories, includeTestDependencies, includeProvidedDependencies, repositoryState);
        }
        catch (RepositoryException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    private Artifact createArtifactFromBundleDescriptor(BundleDescriptor bundleDescriptor) {
        return new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion());
    }

    public BundleDependency resolveBundleDescriptor(BundleDescriptor bundleDescriptor) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving artifact with resolution context: " + this.aetherResolutionContext.toString());
            }
            AetherRepositoryState repositoryState = this.getRepositoryState(this.mavenConfiguration.getLocalMavenRepositoryLocation(), Optional.empty());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null);
            ArtifactResult artifactResult = repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            return BundleDependencyHelper.artifactToBundleDependency(resolvedArtifact, "compile").build();
        }
        catch (ArtifactResolutionException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    public Model getRawPomModel(File artifactFile) {
        return MavenUtils.getPomModel((File)artifactFile);
    }

    public Model getEffectiveModel(File artifactFile, Optional<File> temporaryFolder) {
        return this.getEffectiveModel(artifactFile, temporaryFolder, Optional.empty());
    }

    public List<BundleDependency> resolvePluginBundleDescriptorsDependencies(List<BundleDescriptor> bundleDescriptors) {
        AetherRepositoryState repositoryState = this.getRepositoryState(this.mavenConfiguration.getLocalMavenRepositoryLocation(), Optional.empty());
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRepositories(this.aetherResolutionContext.getRemoteRepositories());
            collectRequest.setDependencies(bundleDescriptors.stream().map(bundleDescriptor -> new Dependency((Artifact)new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), MULE_PLUGIN_CLASSIFIER, "jar", bundleDescriptor.getVersion()), "compile")).collect(Collectors.toList()));
            return this.doResolveDependencies(repositoryState, collectRequest);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the bundleDescriptors [%s]", bundleDescriptors), e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public org.mule.maven.client.api.VersionRangeResult resolveVersionRange(BundleDescriptor bundleDescriptor) {
        AetherRepositoryState repositoryState = this.getRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty());
        try {
            VersionRange.createFromVersionSpec((String)bundleDescriptor.getVersion());
            VersionRangeResult versionRangeResult = repositoryState.getSystem().resolveVersionRange((RepositorySystemSession)repositoryState.getSession(), new VersionRangeRequest(this.createArtifactFromBundleDescriptor(bundleDescriptor), this.aetherResolutionContext.getRemoteRepositories(), null));
            return new DefaultVersionRangeResult(versionRangeResult);
        }
        catch (InvalidVersionSpecificationException | VersionRangeResolutionException e) {
            throw new RuntimeException(String.format("Couldn't resolve version range for bundleDescriptor: '%s'", bundleDescriptor.toString(), e));
        }
    }

    private List<BundleDependency> resolveDependencies(List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> remoteRepositories, boolean enableTestDependencies, boolean enableProvidedDependencies, AetherRepositoryState repositoryState) throws DependencyResolutionException {
        CollectRequest collectRequest = new CollectRequest();
        if (!dependencies.isEmpty()) {
            collectRequest.setDependencies(dependencies);
        }
        if (!managedDependencies.isEmpty()) {
            collectRequest.setManagedDependencies(managedDependencies);
        }
        if (!remoteRepositories.isEmpty()) {
            collectRequest.setRepositories(remoteRepositories);
        }
        return this.doResolveDependencies(repositoryState, collectRequest, enableTestDependencies, enableProvidedDependencies);
    }

    private List<BundleDependency> doResolveDependencies(AetherRepositoryState repositoryState, CollectRequest collectRequest) throws DependencyResolutionException {
        return this.doResolveDependencies(repositoryState, collectRequest, false, false);
    }

    private List<BundleDependency> doResolveDependencies(AetherRepositoryState repositoryState, CollectRequest collectRequest, boolean enableTestDependencies, boolean enableProvidedDependencies) throws DependencyResolutionException {
        Set domainDependencies = collectRequest.getDependencies().stream().filter(dependency -> MULE_DOMAIN_CLASSIFIER.equals(dependency.getArtifact().getClassifier()) && dependency.getScope().equals("provided")).collect(Collectors.toSet());
        collectRequest.setDependencies(collectRequest.getDependencies().stream().filter(dependency -> !domainDependencies.contains(dependency)).collect(Collectors.toList()));
        ArrayList<String> resolutionScopesToExclude = new ArrayList<String>(2);
        resolutionScopesToExclude.add("provided");
        resolutionScopesToExclude.add("test");
        if (enableTestDependencies) {
            resolutionScopesToExclude.remove("test");
        }
        ScopeDependencyFilter resolutionScopeDependencyFilter = new ScopeDependencyFilter(null, resolutionScopesToExclude);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setCollectRequest(collectRequest);
        dependencyRequest.setFilter((DependencyFilter)new AndDependencyFilter(new DependencyFilter[]{resolutionScopeDependencyFilter, (node, parents) -> !node.getData().containsKey("conflict.winner")}));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Collecting and resolving transitive dependencies for request: {}", (Object)collectRequest);
        }
        DependencyResult dependencyResult = repositoryState.getSystem().resolveDependencies((RepositorySystemSession)repositoryState.getSession(), dependencyRequest);
        DependencyNode root = dependencyResult.getRoot();
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept((DependencyVisitor)nlg);
        BundleDependencyHelper bundleDependencyHelper = new BundleDependencyHelper();
        ArrayList<String> scopesToFilterFromResult = new ArrayList<String>(resolutionScopesToExclude);
        if (enableProvidedDependencies && !enableTestDependencies) {
            scopesToFilterFromResult.clear();
            scopesToFilterFromResult.add("test");
        } else if (enableTestDependencies && enableProvidedDependencies) {
            scopesToFilterFromResult.clear();
        }
        ScopeDependencyFilter bundleDependenciesFilter = new ScopeDependencyFilter(null, scopesToFilterFromResult);
        AndDependencyFilter childDependenciesFilter = new AndDependencyFilter(new DependencyFilter[]{new ScopeDependencyFilter(new String[]{null, "provided"}), bundleDependenciesFilter});
        List<BundleDependency> bundleDependencies = nlg.getNodes().stream().filter(node -> !node.getData().containsKey("conflict.winner")).filter(node -> !node.getData().containsKey("plugin-ancestor") || node.getData().get("plugin-ancestor").equals(root)).filter(arg_0 -> AetherMavenClient.lambda$doResolveDependencies$17((DependencyFilter)bundleDependenciesFilter, arg_0)).map(arg_0 -> AetherMavenClient.lambda$doResolveDependencies$18(bundleDependencyHelper, (DependencyFilter)childDependenciesFilter, arg_0)).collect(Collectors.toList());
        if (enableProvidedDependencies) {
            bundleDependencies.addAll(domainDependencies.stream().map(dependency -> BundleDependencyHelper.artifactToBundleDependency(dependency.getArtifact(), dependency.getScope()).build()).collect(Collectors.toList()));
        }
        return bundleDependencies;
    }

    private static Dependency convertModelDependency(org.apache.maven.model.Dependency modelDependency, ArtifactTypeRegistry artifactTypeRegistry) {
        ArtifactType artifactType = artifactTypeRegistry.get(modelDependency.getType());
        if (artifactType == null) {
            artifactType = new DefaultArtifactType(modelDependency.getType(), modelDependency.getType(), modelDependency.getClassifier(), "none");
        }
        DefaultArtifact artifactDependency = new DefaultArtifact(modelDependency.getGroupId(), modelDependency.getArtifactId(), modelDependency.getClassifier() != null ? modelDependency.getClassifier() : artifactType.getClassifier(), artifactType.getExtension(), modelDependency.getVersion(), (Map)("system".equals(modelDependency.getScope()) ? ImmutableMap.of((Object)"localPath", (Object)modelDependency.getSystemPath()) : Collections.emptyMap()), "system".equals(modelDependency.getScope()) ? new File(modelDependency.getSystemPath()) : null);
        Dependency dependency = new Dependency((Artifact)artifactDependency, modelDependency.getScope());
        dependency = dependency.setOptional(Boolean.valueOf(modelDependency.isOptional()));
        dependency = dependency.setExclusions((Collection)modelDependency.getExclusions().stream().map(modelExclusion -> new Exclusion(modelExclusion.getGroupId(), modelExclusion.getArtifactId(), ANY, ANY)).collect(Collectors.toList()));
        return dependency;
    }

    private void setPom(ModelBuildingRequest modelBuildingRequest, File artifactFile, Optional<File> temporaryFolder) {
        Object modelSource;
        if (artifactFile.isFile() && (FilenameUtils.getExtension((String)artifactFile.getName()).equals(POM) || artifactFile.getName().equals(POM_XML))) {
            modelSource = new FileModelSource(artifactFile);
        } else {
            Model rawPomModel = this.getRawPomModel(artifactFile);
            BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setGroupId(rawPomModel.getGroupId() != null ? rawPomModel.getGroupId() : rawPomModel.getParent().getGroupId()).setArtifactId(rawPomModel.getArtifactId()).setVersion(rawPomModel.getVersion() != null ? rawPomModel.getVersion() : rawPomModel.getParent().getVersion()).build();
            modelSource = artifactFile.isDirectory() ? new FileModelSource((File)this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor).get()) : temporaryFolder.map(t -> new FileModelSource((File)this.pomFileSupplierFactory.compressedArtifactSupplier(artifactFile, bundleDescriptor, t).get())).orElse((ModelSource2)new UrlModelSource(MavenUtils.getPomUrlFromJar((File)artifactFile)));
        }
        if (modelSource instanceof FileModelSource) {
            modelBuildingRequest.setPomFile(modelSource.getFile());
        }
        modelBuildingRequest.setModelSource((ModelSource)modelSource);
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Dependency path to not resolved artifacts -> " + unresolvedArtifactPath.toString());
            }
        });
    }

    private static /* synthetic */ BundleDependency lambda$doResolveDependencies$18(BundleDependencyHelper bundleDependencyHelper, DependencyFilter childDependenciesFilter, DependencyNode node) {
        return bundleDependencyHelper.getBundleDependency(node, childDependenciesFilter);
    }

    private static /* synthetic */ boolean lambda$doResolveDependencies$17(DependencyFilter bundleDependenciesFilter, DependencyNode node) {
        return bundleDependenciesFilter.accept(node, Collections.emptyList());
    }

    private class MavenWorkspaceReaderAdapter
    implements WorkspaceReader {
        private final WorkspaceRepository workspaceRepository = new WorkspaceRepository(String.format("worskpace-repository-reactor", new Object[0]));
        private final MavenReactorResolver mavenReactorResolver;

        MavenWorkspaceReaderAdapter(MavenReactorResolver mavenReactorResolver) {
            this.mavenReactorResolver = mavenReactorResolver;
        }

        public WorkspaceRepository getRepository() {
            return this.workspaceRepository;
        }

        public File findArtifact(Artifact artifact) {
            return this.mavenReactorResolver.findArtifact(this.toBundleDescriptor(artifact));
        }

        public BundleDescriptor toBundleDescriptor(Artifact artifact) {
            return new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension()).build();
        }

        public List<String> findVersions(Artifact artifact) {
            return this.mavenReactorResolver.findVersions(this.toBundleDescriptor(artifact));
        }
    }
}

