/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.util.InternalExceptionUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ModuleOperationMessageProcessorChainBuilder
extends DefaultMessageProcessorChainBuilder {
    public static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    public static final String MODULE_CONNECTION_GLOBAL_ELEMENT_NAME = "connection";
    private final Map<String, String> properties;
    private final Map<String, String> parameters;
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final ExpressionManager expressionManager;

    public ModuleOperationMessageProcessorChainBuilder(Map<String, String> properties, Map<String, String> parameters, ExtensionModel extensionModel, OperationModel operationModel, ExpressionManager expressionManager) {
        this.properties = properties;
        this.parameters = parameters;
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.expressionManager = expressionManager;
    }

    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new ModuleOperationProcessorChain("wrapping-operation-module-chain", head, processors, processorForLifecycle, this.properties, this.parameters, this.extensionModel, this.operationModel, this.expressionManager, this.processingStrategy);
    }

    public static class ModuleOperationProcessorChain
    extends DefaultMessageProcessorChainBuilder.DefaultMessageProcessorChain
    implements Processor {
        private final Map<String, Pair<String, MetadataType>> properties;
        private final Map<String, Pair<String, MetadataType>> parameters;
        private final boolean returnsVoid;
        private final ExpressionManager expressionManager;
        private final Optional<String> target;
        private final String targetValue;

        ModuleOperationProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle, Map<String, String> properties, Map<String, String> parameters, ExtensionModel extensionModel, OperationModel operationModel, ExpressionManager expressionManager, ProcessingStrategy processingStrategy) {
            super(name, Optional.ofNullable(processingStrategy), head, processors, processorsForLifecycle);
            List<ParameterModel> propertiesModels = this.getAllProperties(extensionModel);
            this.properties = this.parseParameters(properties, propertiesModels);
            this.target = parameters.containsKey("target") ? Optional.of(parameters.remove("target")) : Optional.empty();
            this.targetValue = parameters.remove("targetValue");
            this.parameters = this.parseParameters(parameters, operationModel.getAllParameterModels());
            this.returnsVoid = MetadataTypeUtils.isVoid((MetadataType)operationModel.getOutput().getType());
            this.expressionManager = expressionManager;
        }

        private List<ParameterModel> getAllProperties(ExtensionModel extensionModel) {
            ArrayList<ParameterModel> result = new ArrayList<ParameterModel>();
            extensionModel.getConfigurationModel(ModuleOperationMessageProcessorChainBuilder.MODULE_CONFIG_GLOBAL_ELEMENT_NAME).ifPresent(configurationModel -> {
                result.addAll(configurationModel.getAllParameterModels());
                configurationModel.getConnectionProviderModel(ModuleOperationMessageProcessorChainBuilder.MODULE_CONNECTION_GLOBAL_ELEMENT_NAME).ifPresent(connectionProviderModel -> result.addAll(connectionProviderModel.getAllParameterModels()));
            });
            return result;
        }

        private Map<String, Pair<String, MetadataType>> parseParameters(Map<String, String> parameters, List<ParameterModel> parameterModels) {
            HashMap<String, Pair<String, MetadataType>> result = new HashMap<String, Pair<String, MetadataType>>();
            for (ParameterModel parameterModel : parameterModels) {
                String parameterName = parameterModel.getName();
                if (!parameters.containsKey(parameterName)) continue;
                String xmlValue = parameters.get(parameterName).trim();
                result.put(parameterName, (Pair<String, MetadataType>)new Pair((Object)xmlValue, (Object)parameterModel.getType()));
            }
            return result;
        }

        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            Map annotation = (Map)this.getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
            String moduleOperationName = (String)annotation.get("moduleName") + ":" + (String)annotation.get("moduleOperation");
            return Flux.from(publisher).doOnNext(event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(moduleOperationName, null))).concatMap(request -> {
                Publisher<CoreEvent> child = MessageProcessors.processWithChildContextDontComplete(this.createEventWithParameters((CoreEvent)request), x$0 -> super.apply(x$0), Optional.ofNullable(this.getLocation()));
                return Flux.from(child).doOnNext(event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop()).onErrorMap(MessagingException.class, this.remapMessagingException()).doOnError(MessagingException.class, me -> ((DefaultFlowCallStack)me.getEvent().getFlowCallStack()).pop()).onErrorResume(MessagingException.class, this.createErrorResumeMapper((CoreEvent)request)).map(eventResult -> this.processResult((CoreEvent)request, (CoreEvent)eventResult));
            });
        }

        private Function<MessagingException, Throwable> remapMessagingException() {
            return me -> {
                EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo((Event)me.getEvent(), (Exception)me, null);
                this.muleContext.getExceptionContextProviders().forEach(cp -> cp.getContextInfo(notificationInfo, (Component)this).forEach((arg_0, arg_1) -> ((MessagingException)me).addInfo(arg_0, arg_1)));
                return me;
            };
        }

        private Function<MessagingException, Publisher<? extends CoreEvent>> createErrorResumeMapper(CoreEvent originalRequest) {
            return throwable -> {
                throwable = this.handleSubChainException((MessagingException)throwable, originalRequest);
                return Mono.from((Publisher)((BaseEventContext)originalRequest.getContext()).error((Throwable)throwable)).then(Mono.error((Throwable)throwable));
            };
        }

        private MessagingException handleSubChainException(MessagingException messagingException, CoreEvent originalRequest) {
            CoreEvent.Builder builder = CoreEvent.builder((CoreEvent)originalRequest).error((Error)messagingException.getEvent().getError().get());
            List errorMappings = InternalExceptionUtils.getErrorMappings((Component)this);
            if (!errorMappings.isEmpty()) {
                Error error = (Error)messagingException.getEvent().getError().get();
                ErrorType errorType = error.getErrorType();
                ErrorType resolvedType = errorMappings.stream().filter(m -> m.match(errorType)).findFirst().map(ErrorMapping::getTarget).orElse(errorType);
                if (!resolvedType.equals(errorType)) {
                    builder.error(ErrorBuilder.builder((Error)error).errorType(resolvedType).build());
                }
            }
            messagingException.setProcessedEvent(builder.build());
            return messagingException;
        }

        private CoreEvent processResult(CoreEvent originalEvent, CoreEvent chainEvent) {
            if (!this.returnsVoid) {
                originalEvent = this.createNewEventFromJustMessage(originalEvent, chainEvent);
            }
            return originalEvent;
        }

        private CoreEvent createNewEventFromJustMessage(CoreEvent request, CoreEvent response) {
            CoreEvent.Builder builder = CoreEvent.builder((CoreEvent)request);
            if (this.target.isPresent()) {
                TypedValue result = this.expressionManager.evaluate(this.targetValue, BindingContextUtils.getTargetBindingContext((Message)response.getMessage()));
                builder.addVariable(this.target.get(), result.getValue(), result.getDataType());
            } else {
                builder.message((Message)InternalMessage.builder((Message)response.getMessage()).build());
            }
            return builder.build();
        }

        private CoreEvent createEventWithParameters(CoreEvent event) {
            CoreEvent.Builder builder = CoreEvent.builder((EventContext)event.getContext());
            builder.message((Message)InternalMessage.builder().nullValue().build());
            this.addVariables(event, builder, this.properties);
            this.addVariables(event, builder, this.parameters);
            return builder.build();
        }

        private void addVariables(CoreEvent event, CoreEvent.Builder builder, Map<String, Pair<String, MetadataType>> unevaluatedMap) {
            unevaluatedMap.entrySet().stream().forEach(entry -> {
                boolean isExpression = this.expressionManager.isExpression((String)((Pair)entry.getValue()).getFirst());
                if (isExpression) {
                    TypedValue<?> evaluatedValue = this.getEvaluatedValue(event, (String)((Pair)entry.getValue()).getFirst(), (MetadataType)((Pair)entry.getValue()).getSecond());
                    builder.addVariable((String)entry.getKey(), evaluatedValue.getValue(), evaluatedValue.getDataType());
                } else {
                    builder.addVariable((String)entry.getKey(), ((Pair)entry.getValue()).getFirst());
                }
            });
        }

        private TypedValue<?> getEvaluatedValue(CoreEvent event, String value, MetadataType metadataType) {
            TypedValue evaluatedResult;
            Processor head = (Processor)this.getProcessorsToExecute().get(0);
            ComponentLocation headLocation = ((Component)head).getLocation();
            if (MetadataFormat.JAVA.equals((Object)metadataType.getMetadataFormat())) {
                evaluatedResult = this.expressionManager.evaluate(value, event, headLocation);
            } else {
                String mediaType = (String)metadataType.getMetadataFormat().getValidMimeTypes().iterator().next();
                DataType expectedOutputType = DataType.builder().type(String.class).mediaType(mediaType).charset(StandardCharsets.UTF_8).build();
                evaluatedResult = this.expressionManager.evaluate(value, expectedOutputType, BindingContextUtils.NULL_BINDING_CONTEXT, event, headLocation, false);
            }
            return evaluatedResult;
        }
    }
}

