/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageProcessors {
    private MessageProcessors() {
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof MessageProcessorChain) {
            return (MessageProcessorChain)processors.get(0);
        }
        return MessageProcessors.buildNewChainWithListOfProcessors(processingStrategy, processors);
    }

    public static MessageProcessorChain buildNewChainWithListOfProcessors(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder();
        processingStrategy.ifPresent(arg_0 -> defaultMessageProcessorChainBuilder.setProcessingStrategy(arg_0));
        return defaultMessageProcessorChainBuilder.chain(processors).build();
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, Processor ... processors) {
        return MessageProcessors.newChain(processingStrategy, Arrays.asList(processors));
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        return MessageProcessors.processToApply(event, processor, false);
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor, boolean completeContext) throws MuleException {
        return MessageProcessors.processToApply(event, processor, completeContext, (Publisher<CoreEvent>)Mono.from((Publisher)((BaseEventContext)event.getContext()).getResponsePublisher()));
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor, boolean completeContext, Publisher<CoreEvent> alternate) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).transform((Function)processor).switchIfEmpty(Mono.from(alternate)).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), completeContext)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), completeContext)).block();
        }
        catch (Throwable e) {
            MuleException muleException = Exceptions.rxExceptionToMuleException((Throwable)e);
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw muleException;
        }
    }

    public static CoreEvent processToApplyWithChildContext(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        try {
            BaseEventContext childContext = MessageProcessors.newChildContext(event, Optional.empty());
            return (CoreEvent)Mono.just((Object)event).transform(publisher -> Mono.from((Publisher)publisher).flatMap(request -> Mono.from(MessageProcessors.internalProcessWithChildContext(request, processor, (EventContext)childContext, false, (Publisher<CoreEvent>)childContext.getResponsePublisher())))).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException((Throwable)e);
        }
    }

    public static Publisher<CoreEvent> process(CoreEvent event, ReactiveProcessor processor) {
        return Mono.just((Object)event).transform((Function)processor).onErrorMap(t -> !(t instanceof MessagingException), t -> {
            if (processor instanceof Component) {
                return new MessagingException(event, t, (Component)processor);
            }
            return new MessagingException(event, t);
        }).switchIfEmpty(Mono.from((Publisher)((BaseEventContext)event.getContext()).getResponsePublisher())).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), true)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), true));
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        BaseEventContext childContext = MessageProcessors.newChildContext(event, componentLocation);
        return MessageProcessors.internalProcessWithChildContext(event, processor, (EventContext)childContext, true, (Publisher<CoreEvent>)childContext.getResponsePublisher());
    }

    public static BaseEventContext newChildContext(CoreEvent event, Optional<ComponentLocation> componentLocation) {
        return DefaultEventContext.child((BaseEventContext)((BaseEventContext)event.getContext()), componentLocation);
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, BaseEventContext childContext) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, (EventContext)childContext, true, (Publisher<CoreEvent>)childContext.getResponsePublisher());
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        BaseEventContext childContext = DefaultEventContext.child((BaseEventContext)((BaseEventContext)event.getContext()), componentLocation, (FlowExceptionHandler)exceptionHandler);
        return MessageProcessors.internalProcessWithChildContext(event, processor, (EventContext)childContext, true, (Publisher<CoreEvent>)childContext.getResponsePublisher());
    }

    private static Publisher<CoreEvent> internalProcessWithChildContext(CoreEvent event, ReactiveProcessor processor, EventContext child, boolean completeParentOnEmpty, Publisher<CoreEvent> responsePublisher) {
        return Mono.just((Object)EventQuickCopy.quickCopy((EventContext)child, (CoreEvent)event)).transform((Function)processor).doOnNext(MessageProcessors.completeSuccessIfNeeded(child, true)).switchIfEmpty(Mono.from(responsePublisher)).map(result -> EventQuickCopy.quickCopy((EventContext)event.getContext(), (CoreEvent)result)).doOnError(MessagingException.class, me -> me.setProcessedEvent(EventQuickCopy.quickCopy((EventContext)event.getContext(), (CoreEvent)me.getEvent()))).doOnSuccess(result -> {
            if (result == null && completeParentOnEmpty) {
                ((BaseEventContext)event.getContext()).success();
            }
        });
    }

    public static Consumer<CoreEvent> completeSuccessIfNeeded(EventContext child, boolean complete) {
        return result -> {
            if (!((BaseEventContext)child).isComplete() && complete) {
                ((BaseEventContext)child).success(result);
            }
        };
    }

    public static Consumer<Throwable> completeErrorIfNeeded(EventContext child, boolean complete) {
        return throwable -> {
            if (!((BaseEventContext)child).isComplete() && complete) {
                ((BaseEventContext)child).error(throwable);
            }
        };
    }

    public static Optional<ProcessingStrategy> getProcessingStrategy(ConfigurationComponentLocator locator, Location rootContainerLocation) {
        return locator.find(rootContainerLocation).filter(loc -> loc instanceof FlowConstruct).map(loc -> ((FlowConstruct)loc).getProcessingStrategy());
    }

    public static Publisher<CoreEvent> transform(Publisher<CoreEvent> publisher, ReactiveProcessor processor) {
        return Flux.from(publisher).transform((Function)processor);
    }

    public static Publisher<CoreEvent> flatMap(Publisher<CoreEvent> publisher, Function<CoreEvent, Publisher<CoreEvent>> function, Component component) {
        return Flux.from(publisher).flatMap(event -> Mono.from((Publisher)((Publisher)function.apply((CoreEvent)event))).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException(event, e, component)));
    }
}

