/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;
import com.mulesoft.mule.runtime.cache.internal.ObjectStoreCachingStrategy;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class CachingMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor,
Initialisable,
Startable,
Stoppable {
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExpressionManager expressionManager;
    private List<Processor> processors;
    private Processor cachedMessageProcessor;
    private boolean cachingStrategyDefault = false;
    private CachingStrategy cachingStrategy;
    private String filterExpression = Boolean.toString(true);

    public void initialise() throws InitialisationException {
        this.cachedMessageProcessor = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), this.processors);
        super.initialise();
        if (this.cachingStrategy == null) {
            this.cachingStrategyDefault = true;
            this.cachingStrategy = this.createDefaultCachingStrategy();
            LifecycleUtils.initialiseIfNeeded((Object)this.cachingStrategy);
        }
    }

    public void start() throws MuleException {
        super.start();
        if (this.cachingStrategyDefault) {
            LifecycleUtils.startIfNeeded((Object)this.cachingStrategy);
        }
    }

    public void stop() throws MuleException {
        if (this.cachingStrategyDefault) {
            LifecycleUtils.stopIfNeeded((Object)this.cachingStrategy);
        }
        super.stop();
    }

    protected CachingStrategy createDefaultCachingStrategy() {
        ObjectStoreCachingStrategy objectStoreCachingStrategy = new ObjectStoreCachingStrategy();
        objectStoreCachingStrategy.setLockFactory(this.lockFactory);
        objectStoreCachingStrategy.setMuleContext(this.muleContext);
        objectStoreCachingStrategy.setObjectStoreManager(this.objectStoreManager);
        objectStoreCachingStrategy.setSchedulerService(this.schedulerService);
        return objectStoreCachingStrategy;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> Mono.subscriberContext().flatMapMany(ctx -> {
            Processor contextPropagatingProcessor = new Processor((Context)ctx){
                private final /* synthetic */ Context val$ctx;
                {
                    this.val$ctx = context;
                }

                public Publisher<CoreEvent> apply(Publisher<CoreEvent> t) {
                    return Flux.from(t).transform((Function)CachingMessageProcessor.this.cachedMessageProcessor).subscriberContext(this.val$ctx);
                }

                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply(event, (ReactiveProcessor)CachingMessageProcessor.this.cachedMessageProcessor);
                }
            };
            if (this.expressionManager.evaluateBoolean(this.filterExpression, event, this.getLocation(), false, true)) {
                return Flux.just((Object)event).transform((Function)this.cachingStrategy.transformProcessor(contextPropagatingProcessor));
            }
            return Flux.just((Object)event).transform((Function)contextPropagatingProcessor);
        }));
    }

    public void setMessageProcessors(List<Processor> messageProcessors) throws MuleException {
        this.processors = messageProcessors;
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.cachedMessageProcessor);
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public void setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }
}

