/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TryScope
extends AbstractMessageProcessorOwner
implements Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryScope.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;
    private FlowExceptionHandler messagingExceptionHandler;
    private List<Processor> processors;

    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.nestedChain == null) {
            return event;
        }
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createScopeTransactionalExecutionTemplate((MuleContext)this.muleContext, (TransactionConfig)this.transactionConfig);
        ExecutionCallback processingCallback = () -> {
            if (TransactionCoordination.isTransactionActive()) {
                TransactionAdapter transaction = (TransactionAdapter)TransactionCoordination.getInstance().getTransaction();
                ComponentLocation lastLocation = transaction.getComponentLocation().orElse(null);
                transaction.setComponentLocation(this.getLocation());
                CoreEvent e = MessageProcessors.processToApply(event, p -> Flux.from((Publisher)p).flatMap(request -> MessageProcessors.processWithChildContext(request, (ReactiveProcessor)this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler)));
                transaction.setComponentLocation(lastLocation);
                return e;
            }
            return MessageProcessors.processToApply(event, p -> Flux.from((Publisher)p).flatMap(request -> MessageProcessors.processWithChildContext(request, (ReactiveProcessor)this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler)));
        };
        try {
            return (CoreEvent)executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction((Processor)this.nestedChain, (TransactionConfig)this.transactionConfig), (Throwable)e);
        }
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        if (this.nestedChain == null) {
            return publisher;
        }
        if (TransactionCoordination.isTransactionActive() || this.transactionConfig.getAction() != 6) {
            return super.apply(publisher);
        }
        return Flux.from(publisher).flatMap(event -> MessageProcessors.processWithChildContext(event, (ReactiveProcessor)this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler));
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public void initialise() throws InitialisationException {
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), this.processors);
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler(Optional.of(this.getRootContainerLocation().toString()));
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.messagingExceptionHandler, (boolean)true, (MuleContext)this.muleContext);
        super.initialise();
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.messagingExceptionHandler, (Logger)LOGGER);
        super.dispose();
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.messagingExceptionHandler);
        super.start();
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.messagingExceptionHandler);
        super.stop();
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }
}

