/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.LoggerMessageProcessor;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.processor.interceptor.AbstractInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.processor.simple.ParseTemplateProcessor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class ReactiveInterceptorAdapter
extends AbstractInterceptorAdapter
implements BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private static final String BEFORE_METHOD_NAME = "before";
    private static final String AFTER_METHOD_NAME = "after";
    private static List macroExpansionInternalParams = Collections.unmodifiableList(Arrays.asList("moduleName", "moduleOperation"));
    private ProcessorInterceptorFactory interceptorFactory;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public ReactiveProcessor apply(Processor component, ReactiveProcessor next) {
        if (!this.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((Component)component).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ProcessorInterceptor interceptor = (ProcessorInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)((Component)component).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        ReactiveProcessor interceptedProcessor = this.doApply(component, next, componentLocation, interceptor, dslParameters.entrySet().stream().filter(param -> !macroExpansionInternalParams.contains(param.getKey())).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
        LOGGER.debug("Interceptor '{}' for processor '{}' configured.", (Object)interceptor, (Object)componentLocation.getLocation());
        return interceptedProcessor;
    }

    protected ReactiveProcessor doApply(Processor component, ReactiveProcessor next, ComponentLocation componentLocation, ProcessorInterceptor interceptor, Map<String, String> dslParameters) {
        if (this.implementsBeforeOrAfter(interceptor)) {
            LOGGER.debug("Configuring interceptor '{}' before and after processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Flux.from((Publisher)publisher).concatMap(event -> Flux.just((Object)event).cast(InternalEvent.class).map(this.doBefore(interceptor, (Component)component, dslParameters)).cast(CoreEvent.class).transform((Function)next).onErrorMap(MessagingException.class, error -> this.createMessagingException((CoreEvent)this.doAfter(interceptor, (Component)component, Optional.of(error.getCause())).apply((InternalEvent)error.getEvent()), error.getCause(), (Component)component, Optional.of(error))).cast(InternalEvent.class).map(this.doAfter(interceptor, (Component)component, Optional.empty())).errorStrategyStop());
        }
        return next;
    }

    protected Function<InternalEvent, InternalEvent> doBefore(ProcessorInterceptor interceptor, Component component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader((ClassLoader)interceptor.getClass().getClassLoader(), () -> interceptor.before(component.getLocation(), this.getResolvedParams(eventWithResolvedParams), (InterceptionEvent)interceptionEvent));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)new MessagingException((CoreEvent)interceptionEvent.resolve(), e.getCause(), component));
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doAfter(ProcessorInterceptor interceptor, Component component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                ClassUtils.withContextClassLoader((ClassLoader)interceptor.getClass().getClassLoader(), () -> interceptor.after(component.getLocation(), (InterceptionEvent)interceptionEvent, thrown));
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)this.createMessagingException((CoreEvent)interceptionEvent.resolve(), e.getCause(), component, Optional.empty()));
            }
        };
    }

    private boolean implementsBeforeOrAfter(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(BEFORE_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class).isDefault() || !interceptor.getClass().getMethod(AFTER_METHOD_NAME, ComponentLocation.class, InterceptionEvent.class, Optional.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private boolean isInterceptable(Processor component) {
        return ((Component)component).getLocation() != null;
    }

    protected InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (this.internalParametersFrom((CoreEvent)event).containsKey("core:interceptionResolvedContext") && (processor = (Processor)this.internalParametersFrom((CoreEvent)event).get("core:interceptionComponent")) instanceof ParametersResolverProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing resolved parameters for processor {}...", (Object)((Component)processor).getLocation().getLocation());
            }
            ((ParametersResolverProcessor)processor).disposeResolvedParameters((ExecutionContext)this.internalParametersFrom((CoreEvent)event).get("core:interceptionResolvedContext"));
        }
        return super.removeResolvedParameters(event);
    }

    protected InternalEvent resolveParameters(InternalEvent event, Component component, Map<String, String> parameters) {
        HashMap<String, ProcessorParameterValue> resolvedParameters = new HashMap<String, ProcessorParameterValue>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), (ProcessorParameterValue)new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    if (component instanceof LoggerMessageProcessor || component instanceof ParseTemplateProcessor) {
                        return this.expressionManager.parseLogTemplate(providedValue, (CoreEvent)event, component.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
                    }
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, component.getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        InternalEvent.Builder builder = InternalEvent.builder((CoreEvent)event);
        this.setInternalParamsForNotParamResolver(component, resolvedParameters, builder);
        return builder.build();
    }

    protected void setInternalParamsForNotParamResolver(Component component, Map<String, ProcessorParameterValue> resolvedParameters, InternalEvent.Builder builder) {
        if (component instanceof ParametersResolverProcessor) {
            try {
                ((ParametersResolverProcessor)component).resolveParameters((CoreEvent.Builder)builder, (params, context) -> {
                    resolvedParameters.putAll(params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new DefaultProcessorParameterValue((String)e.getKey(), null, () -> ((Supplier)e.getValue()).get()))));
                    HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
                    interceptionEventParams.put("core:interceptionResolvedContext", context);
                    interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
                    interceptionEventParams.put("core:interceptionComponent", component);
                    builder.internalParameters(interceptionEventParams);
                });
            }
            catch (ExpressionRuntimeException e) {
                super.setInternalParamsForNotParamResolver(component, resolvedParameters, builder);
            }
            catch (MuleException e) {
                throw new InterceptionException((Throwable)e);
            }
        } else {
            super.setInternalParamsForNotParamResolver(component, resolvedParameters, builder);
        }
    }
}

