/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import com.mulesoft.mule.runtime.core.internal.processor.TransformMessageProcessor;
import com.mulesoft.mule.runtime.core.internal.processor.TransformationTarget;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.exception.ResourceNotFoundException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public abstract class BaseTransformationTarget
extends AbstractComponent
implements TransformationTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformMessageProcessor.class);
    protected String resource;
    protected String script;
    protected LazyValue<String> expression = new LazyValue(this::loadExpression);

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getExpression() {
        return (String)this.expression.get();
    }

    private String loadExpression() {
        if (this.script != null) {
            if (this.resource != null) {
                this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "Both [script] and [resource] parameters were provided, only one should be provided"));
            }
            return this.script;
        }
        if (this.resource == null) {
            this.fail(String.format("Invalid configuration found for component [%s]: \n %s", this.getTargetName(), "No [script] nor [resource] parameters were provided, but one is required"));
        }
        return this.getResourceFrom(this.resource);
    }

    private String getResourceFrom(String resource) {
        String resourceFromStream;
        block18: {
            resourceFromStream = null;
            InputStream resourceAsStream = null;
            try {
                try {
                    resourceAsStream = ClassUtils.getResourceOrFail((String)resource, (boolean)true).openStream();
                    resourceFromStream = IOUtils.toString((InputStream)resourceAsStream);
                }
                catch (IOException | ResourceNotFoundException e) {
                    if (resourceAsStream == null) {
                        try {
                            resourceAsStream = new FileInputStream(resource);
                            resourceFromStream = IOUtils.toString((InputStream)resourceAsStream);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.fail(String.format("Invalid configuration found for parameter 'resource' in component [%s]: \n %s", this.getTargetName(), e.getMessage()));
                        }
                    }
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (IOException iOException) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
                            }
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                block19: {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (IOException iOException) {
                            if (!LOGGER.isDebugEnabled()) break block19;
                            LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
                        }
                    }
                }
                throw throwable;
            }
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException iOException) {
                    if (!LOGGER.isDebugEnabled()) break block18;
                    LOGGER.debug(String.format("Error closing stream for transformation: %s", resource));
                }
            }
        }
        return resourceFromStream;
    }

    private void fail(String message) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
    }
}

