/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.internal.dsl.model.DependencyNode;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ConfigurationDependencyResolver {
    private final ApplicationModel applicationModel;
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private List<DependencyNode> missingElementNames = new ArrayList<DependencyNode>();
    private Set<DependencyNode> alwaysEnabledComponents = Sets.newHashSet();

    public ConfigurationDependencyResolver(ApplicationModel applicationModel, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, Predicate<ComponentIdentifier> isLanguageConstructComponentPredicate) {
        this.applicationModel = applicationModel;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.fillAlwaysEnabledComponents(isLanguageConstructComponentPredicate);
    }

    private Set<DependencyNode> resolveComponentModelDependencies(ComponentModel componentModel) {
        Set<DependencyNode> otherRequiredGlobalComponents = this.resolveComponentDependencies(componentModel);
        return this.findComponentModelsDependencies(otherRequiredGlobalComponents);
    }

    protected Set<DependencyNode> resolveComponentDependencies(final ComponentModel requestedComponentModel) {
        HashSet<DependencyNode> otherDependencies = new HashSet<DependencyNode>();
        requestedComponentModel.getInnerComponents().stream().forEach(childComponent -> otherDependencies.addAll(this.resolveComponentDependencies((ComponentModel)childComponent)));
        final HashSet parametersReferencingDependencies = new HashSet();
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(requestedComponentModel.getIdentifier()).ifPresent(buildingDefinition -> buildingDefinition.getAttributesDefinitions().stream().forEach(attributeDefinition -> attributeDefinition.accept((AttributeDefinitionVisitor)new AbstractAttributeDefinitionVisitor(){

            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                Arrays.stream(definitions).forEach(keyAttributeDefinitionPair -> keyAttributeDefinitionPair.getAttributeDefinition().accept((AttributeDefinitionVisitor)this));
            }

            public void onReferenceSimpleParameter(String reference) {
                parametersReferencingDependencies.add(reference);
            }

            public void onSoftReferenceSimpleParameter(String softReference) {
                parametersReferencingDependencies.add(softReference);
            }

            public void onReferenceConfigurationParameter(String parameterName, Object defaultValue, Optional<TypeConverter> typeConverter) {
                if (requestedComponentModel.getParameters().containsKey(parameterName) && !MuleExtensionUtils.isExpression(requestedComponentModel.getParameters().get(parameterName))) {
                    parametersReferencingDependencies.add(parameterName);
                }
            }
        })));
        for (String parametersReferencingDependency : parametersReferencingDependencies) {
            if (!requestedComponentModel.getParameters().containsKey(parametersReferencingDependency)) continue;
            this.appendTopLevelDependency(otherDependencies, requestedComponentModel, parametersReferencingDependency);
        }
        if (this.isCoreComponent(requestedComponentModel.getIdentifier(), "flow-ref")) {
            this.appendTopLevelDependency(otherDependencies, requestedComponentModel, "name");
        } else if (this.isAggregatorComponent(requestedComponentModel, "aggregatorName")) {
            String name = (String)requestedComponentModel.getParameters().get("aggregatorName");
            DependencyNode dependency = new DependencyNode(name, DependencyNode.Type.INNER);
            if (this.applicationModel.findNamedElement(name).isPresent()) {
                otherDependencies.add(dependency);
            } else {
                this.missingElementNames.add(dependency);
            }
        } else if (this.isCoreComponent(requestedComponentModel.getIdentifier(), "configuration")) {
            this.appendTopLevelDependency(otherDependencies, requestedComponentModel, "defaultErrorHandler-ref");
        }
        return otherDependencies;
    }

    protected Set<DependencyNode> findComponentModelsDependencies(Set<DependencyNode> componentModelNames) {
        HashSet<DependencyNode> componentsToSearchDependencies = new HashSet<DependencyNode>(componentModelNames);
        LinkedHashSet<DependencyNode> foundDependencies = new LinkedHashSet<DependencyNode>();
        HashSet<DependencyNode> alreadySearchedDependencies = new HashSet<DependencyNode>();
        do {
            componentsToSearchDependencies.addAll(foundDependencies);
            for (DependencyNode dependencyNode : componentsToSearchDependencies) {
                if (alreadySearchedDependencies.contains(dependencyNode)) continue;
                alreadySearchedDependencies.add(dependencyNode);
                foundDependencies.addAll(this.resolveComponentDependencies(this.findRequiredComponentModel(dependencyNode.getComponentName())));
            }
            foundDependencies.addAll(componentModelNames);
        } while (!foundDependencies.containsAll(componentsToSearchDependencies));
        return foundDependencies;
    }

    private void appendTopLevelDependency(Set<DependencyNode> otherDependencies, ComponentModel requestedComponentModel, String parametersReferencingDependency) {
        DependencyNode dependency = new DependencyNode((String)requestedComponentModel.getParameters().get(parametersReferencingDependency), DependencyNode.Type.TOP_LEVEL);
        if (this.applicationModel.findTopLevelNamedComponent(dependency.getComponentName()).isPresent()) {
            otherDependencies.add(dependency);
        } else {
            this.missingElementNames.add(dependency);
        }
    }

    private boolean isCoreComponent(ComponentIdentifier componentIdentifier, String name) {
        return componentIdentifier.getNamespace().equals("mule") && componentIdentifier.getName().equals(name);
    }

    private boolean isAggregatorComponent(ComponentModel componentModel, String referenceNameParameter) {
        return componentModel.getIdentifier().getNamespace().equals("aggregators") && componentModel.getParameters().containsKey(referenceNameParameter);
    }

    private ComponentModel findRequiredComponentModel(String name) {
        return this.applicationModel.findNamedElement(name).orElseThrow(() -> new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage((String)("No named component with name " + name))));
    }

    protected ComponentModel findRequiredComponentModel(Location location) {
        Reference foundComponentModelReference = new Reference();
        Optional<ComponentModel> globalComponent = this.applicationModel.findTopLevelNamedComponent(location.getGlobalName());
        globalComponent.ifPresent(componentModel -> this.findComponentWithLocation((ComponentModel)componentModel, location).ifPresent(foundComponentModel -> {
            ComponentModel cfr_ignored_0 = (ComponentModel)foundComponentModelReference.set(foundComponentModel);
        }));
        if (foundComponentModelReference.get() == null) {
            throw new NoSuchComponentModelException(I18nMessageFactory.createStaticMessage((String)("No object found at location " + location.toString())));
        }
        return (ComponentModel)foundComponentModelReference.get();
    }

    private Optional<ComponentModel> findComponentWithLocation(ComponentModel componentModel, Location location) {
        if (componentModel.getComponentLocation().getLocation().equals(location.toString())) {
            return Optional.of(componentModel);
        }
        for (ComponentModel childComponent : componentModel.getInnerComponents()) {
            Optional<ComponentModel> foundComponent = this.findComponentWithLocation(childComponent, location);
            if (!foundComponent.isPresent()) continue;
            return foundComponent;
        }
        return Optional.empty();
    }

    public Collection<String> resolveComponentDependencies(String componentName) {
        try {
            ComponentModel requiredComponentModel = this.findRequiredComponentModel(componentName);
            return this.resolveComponentModelDependencies(requiredComponentModel).stream().filter(dependencyNode -> dependencyNode.isTopLevel()).map(dependencyNode -> dependencyNode.getComponentName()).collect(Collectors.toList());
        }
        catch (NoSuchComponentModelException e) {
            return Collections.emptyList();
        }
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public List<ComponentModel> findRequiredComponentModels(Predicate<ComponentModel> predicate) {
        ArrayList<ComponentModel> components = new ArrayList<ComponentModel>();
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            if (predicate.test((ComponentModel)componentModel)) {
                components.add((ComponentModel)componentModel);
            }
        });
        return components;
    }

    public Set<DependencyNode> resolveAlwaysEnabledComponents() {
        return this.alwaysEnabledComponents;
    }

    private void fillAlwaysEnabledComponents(Predicate<ComponentIdentifier> isLanguageConstructComponentPredicate) {
        this.applicationModel.executeOnEveryRootElement(componentModel -> {
            Optional buildingDefinition = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
            ComponentModel alwaysEnabledComponentModel = buildingDefinition.map(definition -> {
                if (definition.isAlwaysEnabled()) {
                    return componentModel;
                }
                return null;
            }).orElseGet(() -> {
                if (isLanguageConstructComponentPredicate.test(componentModel.getIdentifier())) {
                    return componentModel;
                }
                return null;
            });
            if (alwaysEnabledComponentModel != null) {
                this.addAlwaysEnabledComponent(alwaysEnabledComponentModel);
            }
        });
    }

    private void addAlwaysEnabledComponent(ComponentModel componentModel) {
        if (componentModel.getNameAttribute() != null) {
            this.alwaysEnabledComponents.add(new DependencyNode(componentModel.getNameAttribute(), componentModel.getIdentifier(), DependencyNode.Type.TOP_LEVEL));
        } else if (componentModel.isRoot()) {
            this.alwaysEnabledComponents.add(new DependencyNode(null, componentModel.getIdentifier(), DependencyNode.Type.UNNAMED_TOP_LEVEL));
        }
    }

    public List<DependencyNode> getMissingDependencies() {
        return this.missingElementNames;
    }
}

