/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.threading;

import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.threading.BatchWorkManager;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchWorkManager
implements BatchWorkManager,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBatchWorkManager.class);
    private final ConcurrentMap<BatchJobInstance, WorkTracker> workTrackers = new ConcurrentHashMap<BatchJobInstance, WorkTracker>();
    private Scheduler managementScheduler;
    private BatchEngine batchEngine;
    private MuleContext muleContext;

    public void start() throws MuleException {
        if (!this.batchEngine.getBatchJobs().isEmpty() && this.managementScheduler == null) {
            this.managementScheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withName("batch-management-work-manager"));
        }
    }

    public void stop() {
        if (this.managementScheduler != null) {
            this.managementScheduler.stop();
            this.managementScheduler = null;
        }
    }

    public void executable(BatchJobInstance jobInstance) {
        this.workTrackers.computeIfAbsent(jobInstance, k -> new WorkTracker());
    }

    public void scheduleManagementWork(Runnable work) {
        try {
            this.managementScheduler.submit(work);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            LOGGER.warn("Management pool exhausted. Running in current thread.");
            work.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRecordWork(BatchTransactionContext ctx, Runnable work) throws RejectedExecutionException {
        WorkTracker workTracker;
        if (!this.isMuleStarted(ctx)) {
            return;
        }
        BatchJobInstanceAdapter jobInstance = ctx.getJobInstance();
        ConcurrentMap<BatchJobInstance, WorkTracker> concurrentMap = this.workTrackers;
        synchronized (concurrentMap) {
            workTracker = (WorkTracker)this.workTrackers.get(jobInstance);
            if (workTracker == null) {
                throw new IllegalStateException(String.format("job instance '%s' is not registered as executable", jobInstance.getId()));
            }
        }
        this.batchEngine.getJobFor((BatchJobInstance)jobInstance).submitWork(() -> {
            int n = workTracker.workScheduled();
        }, work, () -> {
            int n = workTracker.workFinished();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStop(BatchJobInstanceAdapter jobInstance) {
        WorkTracker tracker;
        ConcurrentMap<BatchJobInstance, WorkTracker> concurrentMap = this.workTrackers;
        synchronized (concurrentMap) {
            tracker = (WorkTracker)this.workTrackers.remove(jobInstance);
        }
        if (tracker != null) {
            tracker.awaitWorkFinished();
        }
    }

    private boolean isMuleStarted(BatchTransactionContext ctx) {
        if (!this.muleContext.isStarted()) {
            LOGGER.warn(String.format("Mule context is stopped or stopping. Can't schedule task '%s' for instance '%s' of job '%s'", ctx.getId(), ctx.getJobInstance().getId(), ctx.getJob().getName()));
            BatchUtils.rollback((BatchTransactionContext)ctx);
            return false;
        }
        return true;
    }

    @Inject
    @Named(value="batch.engine")
    public void setBatchEngine(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private class WorkTracker {
        private final Lock lock = new ReentrantLock();
        private final Condition noWorkPending = this.lock.newCondition();
        private int workCount = 0;

        private WorkTracker() {
        }

        public int workScheduled() {
            return (Integer)ConcurrencyUtils.withLock((Lock)this.lock, () -> ++this.workCount);
        }

        public int workFinished() {
            return (Integer)ConcurrencyUtils.withLock((Lock)this.lock, () -> {
                int updated;
                if ((updated = --this.workCount) <= 0) {
                    this.noWorkPending.signalAll();
                }
                return updated;
            });
        }

        public void awaitWorkFinished() {
            ConcurrencyUtils.withLock((Lock)this.lock, () -> {
                if (this.workCount > 0) {
                    this.noWorkPending.await();
                }
            });
        }
    }
}

