/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.plugin.maven;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;


/**
 * Build a Mule plugin archive.
 */
@Mojo(name = "package", defaultPhase = LifecyclePhase.PACKAGE, requiresDependencyResolution = ResolutionScope.RUNTIME)
public class PluginPackageMojo extends AbstractPackagePluginMojo
{

    /**
     * If provided, it will be out in the final archive. If not, it will be generated based on the
     * extension manifest.
     */
    @Parameter(defaultValue = PLUGIN_PROPERTIES_FILE_NAME)
    private File customPluginProperties;
    
    @Override
    protected void doAddPluginProperties(File pluginPropertiesFile) throws MojoFailureException
    {
        try
        {
            FileUtils.copyFile(customPluginProperties, pluginPropertiesFile);
        }
        catch (IOException e)
        {
            throw new MojoFailureException("Error copying properties file " + e.getMessage());
        }
    }
}
