/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import static org.apache.commons.lang3.StringUtils.join;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class PluginProperties
{

    private static final String ARTIFACT_EXPORT_CLASS_PACKAGES = "artifact.export.classPackages";
    private static final String ARTIFACT_EXPORT_RESOURCE_PACKAGES = "artifact.export.resourcePackages";
    private static final String EXTENSION_PROPERTIES = "Extension Plugin Properties";

    private List<String> exportedPackages = new LinkedList<>();
    private List<String> exportedResources = new LinkedList<>();

    public void addExportedPackages(List<String> packageNames)
    {
        exportedPackages.addAll(packageNames);
    }

    public void addExportedResources(List<String> resourceNames)
    {
        exportedResources.addAll(resourceNames);
    }

    public void writeTo(OutputStream out) throws IOException
    {
        Properties properties = new Properties();
        properties.setProperty(ARTIFACT_EXPORT_RESOURCE_PACKAGES, join(exportedResources, ","));
        properties.setProperty(ARTIFACT_EXPORT_CLASS_PACKAGES, join(exportedPackages, ","));

        properties.store(out, EXTENSION_PROPERTIES);
    }
}
