/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.plugin.maven.ArtifactFilter;
import org.mule.plugin.maven.Exclusion;
import org.mule.plugin.maven.Inclusion;
import org.mule.plugin.maven.ModuleArchiver;

public abstract class AbstractPackagePluginMojo
extends AbstractMuleMojo {
    protected static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private List<Exclusion> exclusions;
    @Parameter
    private List<Inclusion> inclusions;

    protected abstract void doAddPluginProperties(File var1) throws MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
        this.doExecute();
        File plugin = this.getMuleZipFile();
        try {
            this.createMulePlugin(plugin);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", "", plugin);
    }

    protected void createMulePlugin(File plugin) throws MojoExecutionException, MojoFailureException, ArchiverException {
        ModuleArchiver archiver = new ModuleArchiver();
        this.addToArchiver(archiver);
        archiver.setDestFile(plugin);
        try {
            plugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        this.addDependencies(archiver);
        this.addPluginProperties(archiver);
    }

    private void addPluginProperties(ModuleArchiver moduleArchiver) throws MojoFailureException {
        File pluginPropertiesFile = new File(this.outputDirectory, PLUGIN_PROPERTIES_FILE_NAME);
        this.doAddPluginProperties(pluginPropertiesFile);
        moduleArchiver.add(pluginPropertiesFile);
    }

    private void addDependencies(ModuleArchiver archiver) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            this.getLog().info((CharSequence)String.format("Adding <%1s> as a lib", artifact.getId()));
            archiver.addLib(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions);
        return filter.getArtifactsToArchive();
    }

    protected void initialize() throws MojoFailureException, MojoExecutionException {
    }

    protected void doExecute() throws MojoFailureException, MojoExecutionException {
    }
}

