/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PluginProperties {
    private static final String ARTIFACT_EXPORT_CLASS_PACKAGES = "artifact.export.classPackages";
    private static final String ARTIFACT_EXPORT_RESOURCES = "artifact.export.resources";
    private static final String PLUGIN_DEPENDENCIES = "plugin.dependencies";
    private static final String EXTENSION_PROPERTIES = "Extension Plugin Properties";
    private List<String> exportedPackages = new LinkedList<String>();
    private List<String> pluginDependencies = new LinkedList<String>();
    private List<String> exportedResources = new LinkedList<String>();

    public void addExportedPackages(List<String> packageNames) {
        this.exportedPackages.addAll(packageNames);
    }

    public void addExportedResources(List<String> resourceNames) {
        this.exportedResources.addAll(resourceNames);
    }

    public void addPluginDependencies(Set<String> resourceNames) {
        this.pluginDependencies.addAll(resourceNames);
    }

    public void writeTo(OutputStream out) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(ARTIFACT_EXPORT_RESOURCES, StringUtils.join(this.exportedResources, (String)","));
        properties.setProperty(ARTIFACT_EXPORT_CLASS_PACKAGES, StringUtils.join(this.exportedPackages, (String)","));
        if (!this.pluginDependencies.isEmpty()) {
            properties.setProperty(PLUGIN_DEPENDENCIES, StringUtils.join(this.pluginDependencies, (String)","));
        }
        properties.store(out, EXTENSION_PROPERTIES);
    }
}

