/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.plugin.maven.AbstractPackagePluginMojo;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.plugin.maven.PluginProperties;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PluginPackageMojo
extends AbstractPackagePluginMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="plugin.properties")
    private File customPluginProperties;

    @Override
    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        super.addToArchiver(archiver);
        this.addClasses(archiver);
    }

    @Override
    protected void doAddArtifactProperties(File pluginPropertiesFile) throws MojoFailureException {
        try {
            FileInputStream is = new FileInputStream(this.getPluginPropertiesFile());
            Properties loadProps = new Properties();
            loadProps.load(is);
            FileOutputStream os = new FileOutputStream(pluginPropertiesFile);
            PluginProperties pluginProperties = new PluginProperties(loadProps.getProperty("artifact.export.classPackages"), loadProps.getProperty("artifact.export.resources"), StringUtils.join(this.getPluginDependencies(), (String)","), loadProps.getProperty("plugin.bundle"));
            pluginProperties.writeTo(os);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error copying properties file " + e.getMessage());
        }
    }

    private File getPluginPropertiesFile() {
        if (this.customPluginProperties.exists()) {
            return this.customPluginProperties;
        }
        return new File(this.baseDir, "src/main/resources/plugin.properties");
    }

    @Override
    protected String getArtifactType() {
        return "jar";
    }

    @Override
    protected String getArtifactClassifier() {
        return "mule-plugin";
    }

    @Override
    protected File getMuleArtifactFile() {
        return new File(this.outputDirectory, this.finalName + "-" + "mule-plugin" + ".jar");
    }
}

