/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.mule.raml.implv2.v08.model.RamlImpl08V2;
import org.mule.raml.implv2.v10.model.RamlImpl10V2;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.v2.RamlBuilder;
import org.raml.v2.impl.commons.RamlHeader;
import org.raml.v2.impl.commons.RamlVersion;
import org.raml.v2.impl.commons.model.builder.ModelBuilder;
import org.raml.v2.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.impl.v10.RamlFragment;
import org.raml.v2.loader.ResourceLoader;
import org.raml.v2.model.v10.api.Api;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.utils.StreamUtils;

public class ParserV2Utils {
    public static final String INVALID_HEADER = "Invalid RAML header. Is not one of \"#%RAML 0.8\" or \"#%RAML 1.0\"";

    public static IRaml build(ResourceLoader resourceLoader, String ramlPath) {
        InputStream contentStream = resourceLoader.fetchResource(ramlPath);
        if (contentStream != null) {
            String contentString = StreamUtils.toString((InputStream)contentStream);
            return ParserV2Utils.build(resourceLoader, ramlPath, contentString);
        }
        throw new RuntimeException("Invalid RAML descriptor.");
    }

    public static IRaml build(ResourceLoader resourceLoader, String ramlPath, String content) {
        try {
            RamlHeader header = RamlHeader.parse((String)content);
            RamlBuilder builder = new RamlBuilder();
            RamlDocumentNode ramlNode = (RamlDocumentNode)builder.build(content, resourceLoader, ramlPath);
            if (header.getVersion() == RamlVersion.RAML_10) {
                Api ramlV2 = (Api)ModelBuilder.createRaml(Api.class, (RamlDocumentNode)ramlNode);
                return new RamlImpl10V2(ramlV2);
            }
            org.raml.v2.model.v08.api.Api ramlV2 = (org.raml.v2.model.v08.api.Api)ModelBuilder.createRaml(org.raml.v2.model.v08.api.Api.class, (RamlDocumentNode)ramlNode);
            return new RamlImpl08V2(ramlV2);
        }
        catch (RamlHeader.InvalidHeaderException e) {
            throw new RuntimeException("Invalid RAML descriptor.");
        }
    }

    public static List<String> validate(ResourceLoader resourceLoader, String ramlPath, String content) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            RamlHeader header = RamlHeader.parse((String)content);
            if (header.getVersion() == RamlVersion.RAML_08 || header.getVersion() == RamlVersion.RAML_10 && header.getFragment() == RamlFragment.Default) {
                RamlBuilder builder = new RamlBuilder();
                Node node = builder.build(content, resourceLoader, ramlPath);
                List descendantsWith = node.findDescendantsWith(ErrorNode.class);
                for (ErrorNode errorNode : descendantsWith) {
                    result.add(errorNode.getErrorMessage());
                }
            } else {
                result.add(INVALID_HEADER);
            }
        }
        catch (RamlHeader.InvalidHeaderException e) {
            result.add(INVALID_HEADER);
        }
        return result;
    }
}

