/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class ParameterImpl
implements IParameter {
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;
    private Boolean required;
    private Optional<String> defaultValue;

    public ParameterImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet typeIds = Sets.newHashSet((Object[])TypeId.values());
        typeIds.remove(TypeId.OBJECT);
        typeIds.remove(TypeId.ARRAY);
        this.scalarTypes = Collections2.transform((Collection)typeIds, (Function)new Function<TypeId, String>(){

            @Nullable
            public String apply(@Nullable TypeId input) {
                return input.getType();
            }
        });
    }

    public boolean validate(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    private boolean validate(TypeDeclaration type, String value) {
        List results = type.validate(value);
        return results.isEmpty();
    }

    public void validate(String expectedKey, Object values, String parameterType) throws Exception {
        ArrayList properties = values instanceof Iterable ? Lists.newArrayList((Iterable)((Iterable)values)) : Collections.singletonList(values);
        this.validateParam(this.typeDeclaration, expectedKey, properties, parameterType);
    }

    private void validateParam(TypeDeclaration type, String paramKey, Collection<?> paramValues, String parameterType) throws Exception {
        if (type instanceof ArrayTypeDeclaration) {
            this.validateArray((ArrayTypeDeclaration)type, paramKey, paramValues, parameterType);
        } else if (type instanceof UnionTypeDeclaration) {
            this.validateUnion((UnionTypeDeclaration)type, paramKey, paramValues, parameterType);
        } else if (!(type instanceof AnyTypeDeclaration)) {
            if (paramValues.size() > 1) {
                throw new Exception("Parameter " + paramKey + " is not an array");
            }
            String paramValue = String.valueOf(paramValues.iterator().next());
            if (!this.validate(type, paramValue)) {
                String msg = String.format("Invalid value '%s' for %s %s. %s", paramValues, parameterType, paramKey, this.message(type, paramValue));
                throw new Exception(msg);
            }
        }
    }

    private void validateArray(ArrayTypeDeclaration type, String paramKeym, Collection<?> paramValues, String parameterType) throws Exception {
        Integer minItems = type.minItems();
        int size = paramValues.size();
        if (minItems != null && minItems > size) {
            throw new Exception("Expected min items " + minItems + " for " + paramKeym + " and got " + size);
        }
        Integer maxItems = type.maxItems();
        if (maxItems != null && size > maxItems) {
            throw new Exception("Expected max items " + maxItems + " for " + paramKeym + " and got " + size);
        }
        for (Object paramValue : paramValues) {
            this.validateParam(type.items(), paramKeym, Collections.singletonList(paramValue), parameterType);
        }
    }

    private void validateUnion(UnionTypeDeclaration type, String paramKey, Collection<?> paramValues, String parameterType) throws Exception {
        StringBuilder message = new StringBuilder();
        for (TypeDeclaration unionComponent : type.of()) {
            try {
                unionComponent.type();
                this.validateParam(unionComponent, paramKey, paramValues, parameterType);
                return;
            }
            catch (Exception e) {
                message.append("- For ").append(paramKey).append(" one of the union component failed: ").append(e.getMessage()).append("\n");
            }
        }
        throw new Exception(message.toString());
    }

    public String message(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty() ? "OK" : ((ValidationResult)results.get(0)).getMessage();
    }

    private String message(TypeDeclaration type, String value) {
        List results = type.validate(value);
        return results.isEmpty() ? "OK" : ((ValidationResult)results.get(0)).getMessage();
    }

    public boolean isRequired() {
        if (this.required == null) {
            this.required = this.typeDeclaration.required();
        }
        return this.required;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = Optional.fromNullable((Object)this.typeDeclaration.defaultValue());
        }
        return (String)this.defaultValue.orNull();
    }

    public boolean isRepeat() {
        return false;
    }

    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    public String getExample() {
        if (this.typeDeclaration.example() == null) {
            return null;
        }
        return this.typeDeclaration.example().value();
    }

    public Map<String, String> getExamples() {
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (ExampleSpec example : this.typeDeclaration.examples()) {
            examples.put(example.name(), example.value());
        }
        return examples;
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public boolean isStringArray() {
        return this.isArray() && ((ArrayTypeDeclaration)this.typeDeclaration).items() instanceof StringTypeDeclaration;
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.typeDeclaration.type());
    }

    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }
}

