/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service;

import java.util.Collections;
import java.util.List;
import org.mule.amf.impl.ParserWrapperAmf;
import org.mule.amf.impl.exceptions.ParserException;
import org.mule.parser.service.ParserServiceException;
import org.mule.parser.service.logger.Logger;
import org.mule.parser.service.logger.LoggerFactory;
import org.mule.raml.implv1.ParserWrapperV1;
import org.mule.raml.implv2.ParserWrapperV2;
import org.mule.raml.interfaces.ParserType;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.rule.Severity;

public class ParserService {
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(ParserService.class);
    private Logger logger;

    public ParserService() {
        this(DEFAULT_LOGGER);
    }

    public ParserService(Logger logger) {
        this.logger = logger;
    }

    public ParserWrapper getParser(ApiRef apiRef) {
        return this.getParser(apiRef, ParserType.AUTO);
    }

    public ParserWrapper getParser(ApiRef apiRef, ParserType parserType) {
        ParserType overridden = this.getOverriddenParserType();
        if (overridden != ParserType.AUTO) {
            return this.getParserFor(apiRef, overridden);
        }
        return this.getParserFor(apiRef, parserType);
    }

    private ParserType getOverriddenParserType() {
        String parserValue = System.getProperty(MULE_APIKIT_PARSER);
        if (ParserType.AMF.name().equals(parserValue)) {
            return ParserType.AMF;
        }
        if (ParserType.RAML.name().equals(parserValue)) {
            return ParserType.RAML;
        }
        return ParserType.AUTO;
    }

    private ParserWrapper getParserFor(ApiRef apiRef, ParserType parserType) {
        try {
            Object parserWrapper = parserType == ParserType.RAML ? ParserService.createRamlParserWrapper(apiRef) : ParserWrapperAmf.create((ApiRef)apiRef, (boolean)false);
            IValidationReport validationReport = parserWrapper.validationReport();
            if (validationReport.conforms()) {
                if (parserType == ParserType.AUTO) {
                    parserType = ParserType.AMF;
                }
                return parserWrapper;
            }
            List errorsFound = validationReport.getResults();
            return this.applyFallback(apiRef, parserType, errorsFound);
        }
        catch (Exception e) {
            if (e instanceof ParserServiceException) {
                throw (ParserServiceException)e;
            }
            if (e instanceof ParserException) {
                throw new ParserServiceException(e);
            }
            List<IValidationResult> errors = Collections.singletonList(IValidationResult.fromException((Exception)e));
            return this.applyFallback(apiRef, parserType, errors);
        }
    }

    private ParserWrapper applyFallback(ApiRef apiRef, ParserType parserType, List<IValidationResult> errorsFound) throws ParserServiceException {
        ParserWrapper fallbackParser;
        if (parserType == ParserType.AUTO && (fallbackParser = ParserService.createRamlParserWrapper(apiRef)).validationReport().conforms()) {
            this.logErrors(errorsFound, Severity.WARNING);
            return fallbackParser;
        }
        this.logErrors(errorsFound);
        throw new ParserServiceException(ParserService.buildErrorMessage(errorsFound));
    }

    private void logErrors(List<IValidationResult> validationResults) {
        validationResults.forEach(error -> this.logError((IValidationResult)error, error.getSeverity()));
    }

    private void logErrors(List<IValidationResult> validationResults, Severity overridenSeverity) {
        validationResults.forEach(error -> this.logError((IValidationResult)error, overridenSeverity));
    }

    private void logError(IValidationResult error, Severity severity) {
        if (severity == Severity.INFO) {
            this.logger.info(error.getMessage());
        } else if (severity == Severity.WARNING) {
            this.logger.warn(error.getMessage());
        } else {
            this.logger.error(error.getMessage());
        }
    }

    private static String buildErrorMessage(List<IValidationResult> validationResults) {
        StringBuilder message = new StringBuilder("Invalid API descriptor -- errors found: ");
        message.append(validationResults.size()).append("\n\n");
        for (IValidationResult error : validationResults) {
            message.append(error.getMessage()).append("\n");
        }
        return message.toString();
    }

    private static ParserWrapper createRamlParserWrapper(ApiRef apiRef) {
        String path = apiRef.getLocation();
        ResourceLoader apiLoader = apiRef.getResourceLoader().orElse(null);
        if (ApiVendor.RAML_08.equals((Object)apiRef.getVendor())) {
            return ParserService.createRamlParserWrapperV1(path, apiLoader);
        }
        return ParserService.createRamlParserWrapperV2(path, apiLoader);
    }

    private static ParserWrapperV1 createRamlParserWrapperV1(String path, ResourceLoader apiLoader) {
        ParserWrapperV1 parserWrapperV1;
        if (apiLoader != null) {
            org.raml.parser.loader.ResourceLoader[] resourceLoaderArray = new org.raml.parser.loader.ResourceLoader[2];
            resourceLoaderArray[0] = ParserWrapperV1.getResourceLoaderForPath((String)path);
            resourceLoaderArray[1] = arg_0 -> ((ResourceLoader)apiLoader).getResourceAsStream(arg_0);
            parserWrapperV1 = new ParserWrapperV1(path, resourceLoaderArray);
        } else {
            parserWrapperV1 = new ParserWrapperV1(path);
        }
        return parserWrapperV1;
    }

    private static ParserWrapperV2 createRamlParserWrapperV2(String path, ResourceLoader apiLoader) {
        ParserWrapperV2 parserWrapperV2;
        if (apiLoader != null) {
            org.raml.v2.api.loader.ResourceLoader[] resourceLoaderArray = new org.raml.v2.api.loader.ResourceLoader[2];
            resourceLoaderArray[0] = ParserWrapperV2.getResourceLoaderForPath((String)path);
            resourceLoaderArray[1] = arg_0 -> ((ResourceLoader)apiLoader).getResourceAsStream(arg_0);
            parserWrapperV2 = new ParserWrapperV2(path, resourceLoaderArray);
        } else {
            parserWrapperV2 = new ParserWrapperV2(path);
        }
        return parserWrapperV2;
    }
}

