/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.AnyShape;
import amf.client.model.domain.Operation;
import amf.client.model.domain.Parameter;
import amf.client.model.domain.Payload;
import amf.client.model.domain.Request;
import amf.client.model.domain.Response;
import amf.client.model.domain.Shape;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.MimeTypeImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.QueryStringImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.amf.impl.model.ResponseImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IQueryString;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.ISecurityReference;
import org.mule.raml.interfaces.model.parameter.IParameter;

public class ActionImpl
implements IAction {
    private final ResourceImpl resource;
    private final Operation operation;
    private Map<String, IMimeType> bodies;
    private Map<String, IResponse> responses;
    private Map<String, IParameter> queryParameters;
    private Map<String, IParameter> headers;
    private Map<String, IParameter> resolvedUriParameters;

    public ActionImpl(ResourceImpl resource, Operation operation) {
        this.resource = resource;
        this.operation = operation;
    }

    public IActionType getType() {
        return IActionType.valueOf((String)this.operation.method().value().toUpperCase());
    }

    public boolean hasBody() {
        return !this.getBody().isEmpty();
    }

    public Map<String, IResponse> getResponses() {
        if (this.responses == null) {
            this.responses = ActionImpl.loadResponses(this.operation);
        }
        return this.responses;
    }

    private static Map<String, IResponse> loadResponses(Operation operation) {
        LinkedHashMap<String, IResponse> result = new LinkedHashMap<String, IResponse>();
        for (Response response : operation.responses()) {
            result.put(response.statusCode().value(), new ResponseImpl(response));
        }
        return result;
    }

    public IResource getResource() {
        return this.resource;
    }

    public Map<String, IMimeType> getBody() {
        if (this.bodies == null) {
            this.bodies = ActionImpl.loadBodies(this.operation);
        }
        return this.bodies;
    }

    private static Map<String, IMimeType> loadBodies(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IMimeType> result = new LinkedHashMap<String, IMimeType>();
        request.payloads().stream().filter(payload -> payload.mediaType().nonNull()).forEach(payload -> {
            IMimeType cfr_ignored_0 = result.put(payload.mediaType().value(), new MimeTypeImpl((Payload)payload));
        });
        return result;
    }

    public Map<String, IParameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = ActionImpl.loadQueryParameters(this.operation);
        }
        return this.queryParameters;
    }

    private static Map<String, IParameter> loadQueryParameters(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        request.queryParameters().forEach(parameter -> result.put(parameter.name().value(), new ParameterImpl((Parameter)parameter)));
        return result;
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ActionImpl.loadResolvedUriParameters(this.resource, this.operation);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, IParameter> loadResolvedUriParameters(IResource resource, Operation operation) {
        Map<Object, Object> operationUriParams = operation.request() != null ? operation.request().uriParameters().stream().collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new)) : new HashMap();
        Map uriParameters = resource.getResolvedUriParameters();
        uriParameters.forEach(operationUriParams::putIfAbsent);
        return operationUriParams;
    }

    public Map<String, IParameter> getHeaders() {
        if (this.headers == null) {
            this.headers = this.loadHeaders(this.operation);
        }
        return this.headers;
    }

    private Map<String, IParameter> loadHeaders(Operation operation) {
        Request request = operation.request();
        if (request == null) {
            return Collections.emptyMap();
        }
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        request.headers().forEach(parameter -> result.put(parameter.name().value(), new ParameterImpl((Parameter)parameter)));
        return result;
    }

    public List<ISecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, IParameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, IParameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, IMimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, IResponse response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }

    public IQueryString queryString() {
        Request request = this.operation.request();
        if (request == null) {
            return null;
        }
        Shape shape = request.queryString();
        return shape == null ? null : new QueryStringImpl((AnyShape)shape, request.required().value());
    }
}

